/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.handlers;

import com.radiantminds.roadmap.common.data.entities.common.IIdentifiable;
import com.radiantminds.roadmap.common.data.persistence.PersistenceException;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.EntityInfo;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.IEntityPersistence;
import com.radiantminds.roadmap.common.data.persistence.services.PortfolioPlanPersistence;
import com.radiantminds.roadmap.common.handlers.BadDeveloperException;
import com.radiantminds.roadmap.common.handlers.ClientIdCache;
import com.radiantminds.roadmap.common.handlers.EntityContextPreparationResult;
import com.radiantminds.roadmap.common.handlers.NotAuthorizedException;
import com.radiantminds.roadmap.common.handlers.NotFoundException;
import com.radiantminds.roadmap.common.handlers.VersionMismatchException;
import com.radiantminds.roadmap.common.permissions.PlanPermission;
import com.radiantminds.roadmap.common.permissions.PlanPermissionCheckResult;
import com.radiantminds.roadmap.common.permissions.PlanPermissions;
import com.radiantminds.roadmap.common.rest.common.ResponseBuilder;
import com.radiantminds.roadmap.common.rest.entities.common.ModificationResult;
import java.sql.Connection;
import javax.ws.rs.core.Response;

public class EntityContext<T extends IIdentifiable> {
    private final String entityId;
    private final String clientId;
    private final Long expectedPlanVersion;
    private final Long expectedEntityVersion;
    private T entity;
    private EntityInfo entityInfo;
    private IEntityPersistence<T> entityPersistence;
    private PortfolioPlanPersistence planPersistence;
    private boolean incrementEntityVersion;
    private Long incrementedEntityVersion;
    private boolean incrementPlanVersion;
    private Long incrementedPlanVersion;
    private boolean allowDynamicSchedulingVersionHandling;
    private boolean incrementSchedulingVersion;
    private Long incrementedSchedulingVersion;
    private boolean ignoreVersionConflicts;
    private ClientIdCache clientIdCache;

    private EntityContext(String entityId, Long expectedEntityVersion, Long expectedPlanVersion, String clientId) {
        this.entityId = entityId;
        this.expectedEntityVersion = expectedEntityVersion;
        this.expectedPlanVersion = expectedPlanVersion;
        this.clientId = clientId;
    }

    public String getEntityId() {
        return this.entityId;
    }

    public EntityInfo getEntityInfo() {
        return this.entityInfo;
    }

    public T getEntity() {
        return this.entity;
    }

    public void setIncrementSchedulingVersion(boolean incrementSchedulingVersion) {
        if (!this.allowDynamicSchedulingVersionHandling) {
            throw new BadDeveloperException("Dear developer; though shall not set scheduling version handling dynamically unless the proper annotation value is used.");
        }
        this.incrementSchedulingVersion = incrementSchedulingVersion;
    }

    @Deprecated
    private void incrementVersionsIfNeeded() throws Exception {
        this.incrementVersionsIfNeeded(null);
    }

    private void incrementVersionsIfNeeded(Connection connection) throws Exception {
        if (this.incrementEntityVersion) {
            this.incrementedEntityVersion = this.entityPersistence.incrementVersion(this.entityId);
        }
        if (this.incrementPlanVersion) {
            EntityInfo updatedEntityInfo = this.planPersistence.incrementVersions(connection, this.entityInfo.getPlanId(), this.incrementPlanVersion, this.incrementSchedulingVersion);
            this.incrementedPlanVersion = updatedEntityInfo.getPlanVersion();
            this.incrementedSchedulingVersion = updatedEntityInfo.getSchedulingVersion();
        }
    }

    public Response ok() throws Exception {
        this.incrementVersionsIfNeeded(null);
        return ResponseBuilder.ok(this.expectedPlanVersion, this.entityInfo.getPlanVersion(), this.incrementedPlanVersion, this.incrementedSchedulingVersion, this.ignoreVersionConflicts, null);
    }

    public Response ok(Object retVal) throws Exception {
        this.incrementVersionsIfNeeded(null);
        return ResponseBuilder.ok(this.expectedPlanVersion, this.entityInfo.getPlanVersion(), this.incrementedPlanVersion, this.incrementedSchedulingVersion, this.ignoreVersionConflicts, retVal);
    }

    public Response okForList(Object[] retVal) throws Exception {
        this.incrementVersionsIfNeeded(null);
        return ResponseBuilder.okForArray(this.expectedPlanVersion, this.entityInfo.getPlanVersion(), this.incrementedPlanVersion, this.incrementedSchedulingVersion, this.ignoreVersionConflicts, retVal);
    }

    public Response okForEntityUpdate() throws Exception {
        return this.okForEntityUpdate(null);
    }

    public Response okForEntityUpdate(Object data) throws Exception {
        this.incrementVersionsIfNeeded(null);
        ModificationResult modificationResult = new ModificationResult(this.incrementedEntityVersion, this.entityId);
        if (data != null) {
            modificationResult.setData(data);
        }
        return ResponseBuilder.ok(this.expectedPlanVersion, this.entityInfo.getPlanVersion(), this.incrementedPlanVersion, this.incrementedSchedulingVersion, this.ignoreVersionConflicts, modificationResult);
    }

    EntityContextPreparationResult prepare(IEntityPersistence<T> entityPersistence, PortfolioPlanPersistence planPersistence, ClientIdCache clientIdCache, PlanPermissions planPermissionHandler, PlanPermission ... planPermissions) throws Exception {
        this.entityPersistence = entityPersistence;
        this.planPersistence = planPersistence;
        this.clientIdCache = clientIdCache;
        this.entityInfo = this.entityPersistence.getEntityInfo(this.entityId);
        if (this.entityInfo == null) {
            throw new NotFoundException();
        }
        PlanPermissionCheckResult planAuthentication = planPermissionHandler.check(this.entityInfo.getPlanId(), planPermissions);
        if (planAuthentication.isDenied()) {
            throw new NotAuthorizedException();
        }
        return EntityContextPreparationResult.create(planPermissionHandler, planPermissions, planAuthentication);
    }

    void init(EntityContextPreparationResult preparationResult, boolean incrementEntityVersion, boolean incrementPlanVersion, boolean incrementSchedulingVersion, boolean allowDynamicSchedulingVersionHandling, boolean entityNeeded) throws Exception {
        this.incrementEntityVersion = incrementEntityVersion;
        this.incrementPlanVersion = incrementPlanVersion;
        this.incrementSchedulingVersion = incrementSchedulingVersion;
        this.allowDynamicSchedulingVersionHandling = allowDynamicSchedulingVersionHandling;
        this.ignoreVersionConflicts = this.clientIdCache.isClientLastAccessorOfEntity(this.entityPersistence.getEntityClass(), this.entityId, this.clientId);
        if (!this.ignoreVersionConflicts && this.isVersionConflict()) {
            throw new VersionMismatchException(this.expectedEntityVersion, this.entityInfo.getEntityVersion());
        }
        if (entityNeeded) {
            this.entity = this.loadEntity();
        }
        this.clientIdCache.clientAccessedEntity(this.entityPersistence.getEntityClass(), this.entityId, this.clientId);
        this.incrementedPlanVersion = this.entityInfo.getPlanVersion();
        this.incrementedSchedulingVersion = this.entityInfo.getSchedulingVersion();
        this.incrementedEntityVersion = this.entityInfo.getEntityVersion();
    }

    private boolean isVersionConflict() {
        if (this.expectedEntityVersion == null) {
            return false;
        }
        Long expectedVersion = this.expectedEntityVersion;
        Long actualVersion = this.entityInfo.getEntityVersion();
        return !expectedVersion.equals(actualVersion);
    }

    private T loadEntity() throws PersistenceException, NotFoundException {
        T entity = this.entityPersistence.get(this.entityId);
        if (entity == null) {
            throw new NotFoundException();
        }
        return entity;
    }

    @Deprecated
    public static EntityContext from(String entityId) {
        return new EntityContext(entityId, null, null, null);
    }

    @Deprecated
    public static EntityContext from(String entityId, Long expectedPlanVersion) {
        return new EntityContext(entityId, null, expectedPlanVersion, null);
    }

    @Deprecated
    public static EntityContext from(String entityId, Long expectedPlanVersion, String clientId) {
        return new EntityContext(entityId, null, expectedPlanVersion, clientId);
    }

    @Deprecated
    public static <TEntity extends IIdentifiable> EntityContext from(String entityId, Long expectedEntityVersion, Long expectedPlanVersion) {
        return new EntityContext(entityId, expectedEntityVersion, expectedPlanVersion, null);
    }

    @Deprecated
    public static <TEntity extends IIdentifiable> EntityContext from(String entityId, Long expectedEntityVersion, Long expectedPlanVersion, String clientId) {
        return new EntityContext(entityId, expectedEntityVersion, expectedPlanVersion, clientId);
    }
}

