/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.scheduling.trafo;

import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.IResourceGroup;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.TimeStepPresenceFunction;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.problem.IRoadmapProblemDataSource;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.problem.RoadmapProblem;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.time.ITimePlan;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IBacklog;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IRoadmapProblemStatistics;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.RoadmapProblemStatistics;
import com.atlassian.rm.jpo.scheduling.util.RmIdentifiableUtils;
import com.atlassian.rm.jpo.scheduling.util.graph.CyclesDetectedException;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.radiantminds.roadmap.common.data.entities.plans.PlanningUnit;
import com.radiantminds.roadmap.common.data.entities.plans.SchedulingConfig;
import com.radiantminds.roadmap.common.data.entities.plans.SchedulingPlan;
import com.radiantminds.roadmap.common.scheduling.common.ITimeTransformer;
import com.radiantminds.roadmap.common.scheduling.common.TimeTransformer;
import com.radiantminds.roadmap.common.scheduling.trafo.IRoadmapPlanningProblemTransformer;
import com.radiantminds.roadmap.common.scheduling.trafo.NoEstimatedWorkItemsDefinedException;
import com.radiantminds.roadmap.common.scheduling.trafo.RoadmapProblemDataSource;
import com.radiantminds.roadmap.common.scheduling.trafo.WorkDayPresenceFunctionFactory;
import com.radiantminds.roadmap.common.scheduling.trafo.backlog.BacklogTransformer;
import com.radiantminds.roadmap.common.scheduling.trafo.release.TimePlanTransformer;
import com.radiantminds.roadmap.common.scheduling.trafo.settings.SchedulingConfigurationTransformationResult;
import com.radiantminds.roadmap.common.scheduling.trafo.settings.SettingsTransformer;
import com.radiantminds.roadmap.common.scheduling.trafo.teams.PointBasedTeamsTransformer;
import com.radiantminds.roadmap.common.scheduling.trafo.teams.TeamsTransformationResult;
import com.radiantminds.roadmap.common.scheduling.trafo.teams.TeamsTransformer;
import com.radiantminds.roadmap.common.scheduling.trafo.teams.TimeBasedTeamsTransformer;
import java.util.Set;
import javax.annotation.concurrent.Immutable;
import org.javasimon.SimonManager;
import org.javasimon.Split;
import org.javasimon.Stopwatch;

@Immutable
public class RoadmapProblemTransformer
implements IRoadmapPlanningProblemTransformer {
    private static final Log LOGGER = Log.with(RoadmapProblemTransformer.class);
    private final TimeBasedTeamsTransformer timeBasedTeamTransformer;
    private final PointBasedTeamsTransformer pointBasedTeamTransformer;
    private final BacklogTransformer BacklogTransformer;
    private final SettingsTransformer settingsTransformer;
    private final TimePlanTransformer timePlanTransformer;

    RoadmapProblemTransformer(TimeBasedTeamsTransformer timeBasedTeamTransformer, PointBasedTeamsTransformer pointBasedTeamTransformer, BacklogTransformer BacklogTransformer2, SettingsTransformer settingsTransformer, TimePlanTransformer timePlanTransformer) {
        this.timeBasedTeamTransformer = timeBasedTeamTransformer;
        this.pointBasedTeamTransformer = pointBasedTeamTransformer;
        this.BacklogTransformer = BacklogTransformer2;
        this.settingsTransformer = settingsTransformer;
        this.timePlanTransformer = timePlanTransformer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IRoadmapProblemDataSource createProblemDataSource(SchedulingPlan plan) throws CyclesDetectedException, NoEstimatedWorkItemsDefinedException {
        Stopwatch stopwatch = SimonManager.getStopwatch("transformation");
        Split split = stopwatch.start();
        try {
            LOGGER.debug("create portfolio planning problem instance for plan: %s", plan);
            SchedulingConfigurationTransformationResult settingsTransformation = this.settingsTransformer.transformSettings(plan);
            SchedulingConfig planConfiguration = plan.getPlanConfiguration();
            TeamsTransformer teamTransformer = this.selectTeamTransformer(planConfiguration.getPlanningUnit());
            TeamsTransformationResult teamTransformationResult = teamTransformer.createResourceGroups(plan, settingsTransformation.getResourceTypeMapping());
            Set<IResourceGroup> resourceGroups = teamTransformationResult.getResourceGroups();
            ITimePlan timePlan = this.timePlanTransformer.transformTimePlan(plan, RmIdentifiableUtils.getIds(resourceGroups));
            IBacklog backlog = this.BacklogTransformer.transformBacklog(plan, teamTransformationResult, timePlan, settingsTransformation.getProcessingDefinition());
            IRoadmapProblemStatistics statistics = RoadmapProblemStatistics.createInstance(Sets.newHashSet(backlog.getProcessingItems()), resourceGroups);
            RoadmapProblem problem = new RoadmapProblem(backlog, resourceGroups, timePlan, settingsTransformation.getProcessingDefinition(), statistics);
            RoadmapProblemDataSource dataSource = new RoadmapProblemDataSource(problem);
            LOGGER.debug("created data source: %s", dataSource);
            RoadmapProblemDataSource roadmapProblemDataSource = dataSource;
            return roadmapProblemDataSource;
        }
        finally {
            split.stop();
        }
    }

    private TeamsTransformer selectTeamTransformer(String planningUnit) {
        if (planningUnit.equals(PlanningUnit.DAYS.unit()) || planningUnit.equals(PlanningUnit.HOURS.unit())) {
            return this.timeBasedTeamTransformer;
        }
        return this.pointBasedTeamTransformer;
    }

    public static RoadmapProblemTransformer createInstance(ITimeTransformer timeTransformer, SchedulingPlan plan, int planningHorizonInDays) {
        Preconditions.checkNotNull((Object)timeTransformer, (Object)"time transformer must not be null");
        Preconditions.checkNotNull((Object)plan);
        TimeStepPresenceFunction timeStepPresenceFunction = WorkDayPresenceFunctionFactory.createForPlan(timeTransformer, plan);
        return new RoadmapProblemTransformer(new TimeBasedTeamsTransformer(timeTransformer, timeStepPresenceFunction), new PointBasedTeamsTransformer(timeTransformer, timeStepPresenceFunction), new BacklogTransformer(timeTransformer, plan.getPlanConfiguration()), SettingsTransformer.createInstance(planningHorizonInDays, timeTransformer), new TimePlanTransformer(timeTransformer));
    }

    public static RoadmapProblemTransformer createInstance(SchedulingPlan plan, int planningHorizonInDays) {
        TimeTransformer timeTransformer = TimeTransformer.createFromPlan(plan);
        TimeStepPresenceFunction timeStepPresenceFunction = WorkDayPresenceFunctionFactory.createForPlan(timeTransformer, plan);
        return new RoadmapProblemTransformer(new TimeBasedTeamsTransformer(timeTransformer, timeStepPresenceFunction), new PointBasedTeamsTransformer(timeTransformer, timeStepPresenceFunction), new BacklogTransformer(timeTransformer, plan.getPlanConfiguration()), SettingsTransformer.createInstance(planningHorizonInDays, timeTransformer), new TimePlanTransformer(timeTransformer));
    }
}

