/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.utils.estimate;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.radiantminds.roadmap.common.data.entities.common.IExtensionLink;
import com.radiantminds.roadmap.common.data.entities.plans.FullContentSchedulingPlan;
import com.radiantminds.roadmap.common.data.entities.plans.PlanningUnit;
import com.radiantminds.roadmap.common.data.entities.workitems.IEstimationEnrichedWorkItem;
import com.radiantminds.roadmap.common.data.entities.workitems.IProgress;
import com.radiantminds.roadmap.common.data.entities.workitems.IWorkItem;
import com.radiantminds.roadmap.common.data.entities.workitems.WorkItemStatus;
import com.radiantminds.roadmap.common.extensions.workitems.ProgressData;
import com.radiantminds.roadmap.common.extensions.workitems.StatusData;
import com.radiantminds.roadmap.common.utils.estimate.EstimateConversionUtil;
import com.radiantminds.roadmap.common.utils.estimate.EstimateData;
import com.radiantminds.roadmap.common.utils.estimate.EstimateDataAdaptions;
import com.radiantminds.roadmap.common.utils.estimate.EstimateReplanningSuggestion;
import com.radiantminds.roadmap.common.utils.estimate.EstimateReplanningSuggestionBuilder;
import com.radiantminds.roadmap.common.utils.estimate.ProgressTools;
import com.radiantminds.roadmap.common.utils.estimate.SuggestionMode;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

final class EstimateSuggestionUtil {
    EstimateSuggestionUtil() {
    }

    public static EstimateReplanningSuggestion computeEstimateSuggestions(FullContentSchedulingPlan plan, IEstimationEnrichedWorkItem workItem, Map<String, ProgressData> progressMap, Map<String, StatusData> statusMap, Map<String, Double> stagePercentages, SuggestionMode suggestionMode) {
        Double hoursPerDay;
        Optional<WorkItemStatus> workItemStatus = EstimateSuggestionUtil.getMergedStatus(workItem, statusMap);
        if (!workItemStatus.isPresent()) {
            return null;
        }
        if (suggestionMode == SuggestionMode.SIMPLE) {
            return EstimateSuggestionUtil.toStatusSuggestion((WorkItemStatus)((Object)workItemStatus.get()));
        }
        final PlanningUnit planningUnit = PlanningUnit.from(plan.getPlanConfiguration().getPlanningUnit());
        IProgress progress = EstimateSuggestionUtil.getMergedProgress(planningUnit, hoursPerDay = plan.getPlanConfiguration().getHoursPerDay(), workItem, progressMap);
        if (progress == null) {
            return EstimateSuggestionUtil.toStatusSuggestion((WorkItemStatus)((Object)workItemStatus.get()));
        }
        Map<String, ProgressData> progressPerStage = ProgressTools.getProgressPerStage(workItem, progressMap);
        EstimateData data = EstimateData.createFrom(plan, workItem.getCurrentEstimates());
        Double suggestedTotalEstimate = null;
        HashMap suggestedStageEstimates = Maps.newHashMap();
        final HashMap suggestedSkillEstimates = Maps.newHashMap();
        EstimateDataAdaptions.NodeAdaptionFunction skillLevelAdaption = new EstimateDataAdaptions.NodeAdaptionFunction(){

            @Override
            public void adaptSubNodes(EstimateData node, double stageTargetEstimate) {
                EstimateDataAdaptions.adaptProportionally(node.getSubEstimates(), stageTargetEstimate, suggestedSkillEstimates, null);
            }
        };
        if (progressPerStage.size() == 0) {
            double targetEstimate = progress.getSum() * (1.0 - progress.getPercentage());
            if (data.getSelfValue() != null || data.getSum() == 0.0) {
                double doubleSelfValue = ((Number)Objects.firstNonNull((Object)data.getSelfValue(), (Object)0L)).doubleValue();
                if (targetEstimate > doubleSelfValue) {
                    suggestedTotalEstimate = targetEstimate;
                } else if (targetEstimate < doubleSelfValue) {
                    if (plan.getStages().size() > 0) {
                        EstimateData brokenDownData = EstimateData.createForStagePercentages(plan, stagePercentages, doubleSelfValue);
                        EstimateDataAdaptions.storeStageValues(brokenDownData, suggestedStageEstimates);
                        EstimateDataAdaptions.decrementNodeByNode(brokenDownData, targetEstimate, suggestedStageEstimates, null);
                    } else {
                        suggestedTotalEstimate = targetEstimate;
                    }
                }
            } else if (data.getSubEstimates() != null) {
                if (targetEstimate > data.getSum()) {
                    EstimateDataAdaptions.adaptProportionally(data.getSubEstimates(), targetEstimate, suggestedStageEstimates, skillLevelAdaption);
                } else if (targetEstimate < data.getSum()) {
                    EstimateDataAdaptions.decrementNodeByNode(data, targetEstimate, suggestedStageEstimates, skillLevelAdaption);
                }
            }
        } else {
            Map stageTargetValues = Maps.transformValues(progressPerStage, (Function)new Function<ProgressData, Double>(){

                public Double apply(@Nullable ProgressData progress) {
                    IProgress normalizedProgress = EstimateSuggestionUtil.toNormalizedProgress(progress.getSum(), progress.getDonePercentage(), planningUnit, hoursPerDay);
                    return normalizedProgress.getSum() * (1.0 - normalizedProgress.getPercentage());
                }
            });
            if (data.getSelfValue() != null) {
                EstimateData brokenDownData = EstimateData.createForStagePercentages(plan, stagePercentages, data.getSelfValue());
                EstimateDataAdaptions.storeStageValues(brokenDownData, suggestedStageEstimates);
                EstimateDataAdaptions.setNodesToValues(brokenDownData.getSubEstimates(), stageTargetValues, suggestedStageEstimates, null);
            } else if (data.getSubEstimates() != null) {
                EstimateDataAdaptions.setNodesToValues(data.getSubEstimates(), stageTargetValues, suggestedStageEstimates, skillLevelAdaption);
            } else {
                throw new RuntimeException("Unexpected path reached in replanning suggestion calculation.");
            }
        }
        return EstimateReplanningSuggestionBuilder.build(workItem.getCurrentEstimates(), plan, workItemStatus, suggestedTotalEstimate, suggestedStageEstimates, suggestedSkillEstimates);
    }

    private static EstimateReplanningSuggestion toStatusSuggestion(WorkItemStatus status) {
        if (WorkItemStatus.COMPLETED == status) {
            return new EstimateReplanningSuggestion(status.value());
        }
        return null;
    }

    private static IProgress toNormalizedProgress(double sum, final double percentage, PlanningUnit planningUnit, Double hoursPerDay) {
        final double adaptedSum = sum * EstimateConversionUtil.getCoefficient(planningUnit, hoursPerDay);
        return new IProgress(){

            @Override
            public Double getPercentage() {
                return percentage;
            }

            @Override
            public Double getSum() {
                return adaptedSum;
            }
        };
    }

    private static IProgress getMergedProgress(PlanningUnit planningUnit, Double hoursPerDay, IWorkItem workItem, Map<String, ProgressData> linkProgressMap) {
        Set<ProgressData> linkProgressesForItem = EstimateSuggestionUtil.getProgressesForItem(workItem, linkProgressMap);
        if (linkProgressesForItem.isEmpty()) {
            return null;
        }
        double sumSum = 0.0;
        double doneSum = 0.0;
        boolean allDone = true;
        HashSet allProgresses = Sets.newHashSet(linkProgressesForItem);
        for (ProgressData progress : allProgresses) {
            allDone = allDone && progress.isDone();
            double sum = progress.getSum();
            sumSum += sum;
            doneSum += progress.getDonePercentage() * sum;
        }
        double percentage = sumSum > 0.0 ? doneSum / sumSum : (allDone ? 1.0 : 0.0);
        return EstimateSuggestionUtil.toNormalizedProgress(sumSum, percentage, planningUnit, hoursPerDay);
    }

    private static Optional<WorkItemStatus> getMergedStatus(IWorkItem workItem, Map<String, StatusData> statuses) {
        Set<StatusData> workItemStatuses = EstimateSuggestionUtil.getStatusesForItem(workItem, statuses);
        if (workItemStatuses.isEmpty()) {
            return Optional.absent();
        }
        if (Iterables.all(workItemStatuses, (Predicate)new Predicate<StatusData>(){

            public boolean apply(StatusData statusData) {
                return statusData.isDone();
            }
        })) {
            return Optional.of((Object)((Object)WorkItemStatus.COMPLETED));
        }
        return Optional.of((Object)((Object)WorkItemStatus.OPEN));
    }

    private static Set<ProgressData> getProgressesForItem(IWorkItem workItem, final Map<String, ProgressData> progresses) {
        return EstimateSuggestionUtil.getForItem(workItem, new Function<String, ProgressData>(){

            public ProgressData apply(@Nullable String key) {
                return (ProgressData)progresses.get(key);
            }
        });
    }

    private static Set<StatusData> getStatusesForItem(IWorkItem workItem, final Map<String, StatusData> statuses) {
        return EstimateSuggestionUtil.getForItem(workItem, new Function<String, StatusData>(){

            public StatusData apply(@Nullable String key) {
                return (StatusData)statuses.get(key);
            }
        });
    }

    private static <T> Set<T> getForItem(IWorkItem workItem, Function<String, T> getterFunction) {
        HashSet elements = Sets.newHashSet();
        List<IExtensionLink> extensionLinks = workItem.getExtensionLinks();
        for (IExtensionLink extensionLink : extensionLinks) {
            Object element = getterFunction.apply((Object)extensionLink.getExtensionLink());
            if (element == null) continue;
            elements.add(element);
        }
        return elements;
    }
}

