/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.okhttp.internal;

import com.squareup.okhttp.Protocol;
import com.squareup.okhttp.internal.Internal;
import com.squareup.okhttp.internal.OptionalMethod;
import com.squareup.okhttp.internal.Util;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import javax.net.ssl.SSLSocket;
import okio.Buffer;

public class Platform {
    private static final Platform PLATFORM = Platform.findPlatform();

    public static Platform get() {
        return PLATFORM;
    }

    public String getPrefix() {
        return "OkHttp";
    }

    public void logW(String warning) {
        System.out.println(warning);
    }

    public void tagSocket(Socket socket) throws SocketException {
    }

    public void untagSocket(Socket socket) throws SocketException {
    }

    public URI toUriLenient(URL url) throws URISyntaxException {
        return url.toURI();
    }

    public void configureTlsExtensions(SSLSocket sslSocket, String hostname, List<Protocol> protocols) {
    }

    public void afterHandshake(SSLSocket sslSocket) {
    }

    public String getSelectedProtocol(SSLSocket socket) {
        return null;
    }

    public void connectSocket(Socket socket, InetSocketAddress address, int connectTimeout) throws IOException {
        socket.connect(address, connectTimeout);
    }

    private static Platform findPlatform() {
        try {
            try {
                Class.forName("com.android.org.conscrypt.OpenSSLSocketImpl");
            }
            catch (ClassNotFoundException ignored) {
                Class.forName("org.apache.harmony.xnet.provider.jsse.OpenSSLSocketImpl");
            }
            Method trafficStatsTagSocket = null;
            Method trafficStatsUntagSocket = null;
            try {
                Class<?> trafficStats = Class.forName("android.net.TrafficStats");
                trafficStatsTagSocket = trafficStats.getMethod("tagSocket", Socket.class);
                trafficStatsUntagSocket = trafficStats.getMethod("untagSocket", Socket.class);
            }
            catch (ClassNotFoundException ignored) {
            }
            catch (NoSuchMethodException ignored) {
                // empty catch block
            }
            return new Android(trafficStatsTagSocket, trafficStatsUntagSocket);
        }
        catch (ClassNotFoundException ignored) {
            try {
                String negoClassName = "org.eclipse.jetty.alpn.ALPN";
                Class<?> negoClass = Class.forName(negoClassName);
                Class<?> providerClass = Class.forName(negoClassName + "$Provider");
                Class<?> clientProviderClass = Class.forName(negoClassName + "$ClientProvider");
                Class<?> serverProviderClass = Class.forName(negoClassName + "$ServerProvider");
                Method putMethod = negoClass.getMethod("put", SSLSocket.class, providerClass);
                Method getMethod = negoClass.getMethod("get", SSLSocket.class);
                Method removeMethod = negoClass.getMethod("remove", SSLSocket.class);
                return new JdkWithJettyBootPlatform(putMethod, getMethod, removeMethod, clientProviderClass, serverProviderClass);
            }
            catch (ClassNotFoundException ignored2) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            return new Platform();
        }
    }

    static byte[] concatLengthPrefixed(List<Protocol> protocols) {
        Buffer result = new Buffer();
        int size = protocols.size();
        for (int i = 0; i < size; ++i) {
            Protocol protocol = protocols.get(i);
            if (protocol == Protocol.HTTP_1_0) continue;
            result.writeByte(protocol.toString().length());
            result.writeUtf8(protocol.toString());
        }
        return result.readByteArray();
    }

    private static class JettyNegoProvider
    implements InvocationHandler {
        private final List<String> protocols;
        private boolean unsupported;
        private String selected;

        public JettyNegoProvider(List<String> protocols) {
            this.protocols = protocols;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String methodName = method.getName();
            Class<?> returnType = method.getReturnType();
            if (args == null) {
                args = Util.EMPTY_STRING_ARRAY;
            }
            if (methodName.equals("supports") && Boolean.TYPE == returnType) {
                return true;
            }
            if (methodName.equals("unsupported") && Void.TYPE == returnType) {
                this.unsupported = true;
                return null;
            }
            if (methodName.equals("protocols") && args.length == 0) {
                return this.protocols;
            }
            if ((methodName.equals("selectProtocol") || methodName.equals("select")) && String.class == returnType && args.length == 1 && args[0] instanceof List) {
                List peerProtocols = (List)args[0];
                int size = peerProtocols.size();
                for (int i = 0; i < size; ++i) {
                    if (!this.protocols.contains(peerProtocols.get(i))) continue;
                    this.selected = (String)peerProtocols.get(i);
                    return this.selected;
                }
                this.selected = this.protocols.get(0);
                return this.selected;
            }
            if ((methodName.equals("protocolSelected") || methodName.equals("selected")) && args.length == 1) {
                this.selected = (String)args[0];
                return null;
            }
            return method.invoke((Object)this, args);
        }
    }

    private static class JdkWithJettyBootPlatform
    extends Platform {
        private final Method putMethod;
        private final Method getMethod;
        private final Method removeMethod;
        private final Class<?> clientProviderClass;
        private final Class<?> serverProviderClass;

        public JdkWithJettyBootPlatform(Method putMethod, Method getMethod, Method removeMethod, Class<?> clientProviderClass, Class<?> serverProviderClass) {
            this.putMethod = putMethod;
            this.getMethod = getMethod;
            this.removeMethod = removeMethod;
            this.clientProviderClass = clientProviderClass;
            this.serverProviderClass = serverProviderClass;
        }

        @Override
        public void configureTlsExtensions(SSLSocket sslSocket, String hostname, List<Protocol> protocols) {
            ArrayList<String> names = new ArrayList<String>(protocols.size());
            int size = protocols.size();
            for (int i = 0; i < size; ++i) {
                Protocol protocol = protocols.get(i);
                if (protocol == Protocol.HTTP_1_0) continue;
                names.add(protocol.toString());
            }
            try {
                Object provider = Proxy.newProxyInstance(Platform.class.getClassLoader(), new Class[]{this.clientProviderClass, this.serverProviderClass}, (InvocationHandler)new JettyNegoProvider(names));
                this.putMethod.invoke(null, sslSocket, provider);
            }
            catch (InvocationTargetException e) {
                throw new AssertionError((Object)e);
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e);
            }
        }

        @Override
        public void afterHandshake(SSLSocket sslSocket) {
            try {
                this.removeMethod.invoke(null, sslSocket);
            }
            catch (IllegalAccessException ignored) {
                throw new AssertionError();
            }
            catch (InvocationTargetException ignored) {
                throw new AssertionError();
            }
        }

        @Override
        public String getSelectedProtocol(SSLSocket socket) {
            try {
                JettyNegoProvider provider = (JettyNegoProvider)Proxy.getInvocationHandler(this.getMethod.invoke(null, socket));
                if (!provider.unsupported && provider.selected == null) {
                    Internal.logger.log(Level.INFO, "ALPN callback dropped: SPDY and HTTP/2 are disabled. Is alpn-boot on the boot class path?");
                    return null;
                }
                return provider.unsupported ? null : provider.selected;
            }
            catch (InvocationTargetException e) {
                throw new AssertionError();
            }
            catch (IllegalAccessException e) {
                throw new AssertionError();
            }
        }
    }

    private static class Android
    extends Platform {
        private static final OptionalMethod<Socket> SET_USE_SESSION_TICKETS = new OptionalMethod(null, "setUseSessionTickets", Boolean.TYPE);
        private static final OptionalMethod<Socket> SET_HOSTNAME = new OptionalMethod(null, "setHostname", String.class);
        private static final OptionalMethod<Socket> GET_ALPN_SELECTED_PROTOCOL = new OptionalMethod(byte[].class, "getAlpnSelectedProtocol", new Class[0]);
        private static final OptionalMethod<Socket> SET_ALPN_PROTOCOLS = new OptionalMethod(null, "setAlpnProtocols", byte[].class);
        private final Method trafficStatsTagSocket;
        private final Method trafficStatsUntagSocket;

        private Android(Method trafficStatsTagSocket, Method trafficStatsUntagSocket) {
            this.trafficStatsTagSocket = trafficStatsTagSocket;
            this.trafficStatsUntagSocket = trafficStatsUntagSocket;
        }

        @Override
        public void connectSocket(Socket socket, InetSocketAddress address, int connectTimeout) throws IOException {
            try {
                socket.connect(address, connectTimeout);
            }
            catch (SecurityException se) {
                IOException ioException = new IOException("Exception in connect");
                ioException.initCause(se);
                throw ioException;
            }
        }

        @Override
        public void configureTlsExtensions(SSLSocket sslSocket, String hostname, List<Protocol> protocols) {
            boolean alpnSupported;
            if (hostname != null) {
                SET_USE_SESSION_TICKETS.invokeOptionalWithoutCheckedException(sslSocket, true);
                SET_HOSTNAME.invokeOptionalWithoutCheckedException(sslSocket, hostname);
            }
            if (!(alpnSupported = SET_ALPN_PROTOCOLS.isSupported(sslSocket))) {
                return;
            }
            Object[] parameters = new Object[]{Android.concatLengthPrefixed(protocols)};
            SET_ALPN_PROTOCOLS.invokeWithoutCheckedException(sslSocket, parameters);
        }

        @Override
        public String getSelectedProtocol(SSLSocket socket) {
            boolean alpnSupported = GET_ALPN_SELECTED_PROTOCOL.isSupported(socket);
            if (!alpnSupported) {
                return null;
            }
            byte[] alpnResult = (byte[])GET_ALPN_SELECTED_PROTOCOL.invokeWithoutCheckedException(socket, new Object[0]);
            if (alpnResult != null) {
                return new String(alpnResult, Util.UTF_8);
            }
            return null;
        }

        @Override
        public void tagSocket(Socket socket) throws SocketException {
            if (this.trafficStatsTagSocket == null) {
                return;
            }
            try {
                this.trafficStatsTagSocket.invoke(null, socket);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e.getCause());
            }
        }

        @Override
        public void untagSocket(Socket socket) throws SocketException {
            if (this.trafficStatsUntagSocket == null) {
                return;
            }
            try {
                this.trafficStatsUntagSocket.invoke(null, socket);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e.getCause());
            }
        }
    }
}

