/*
 * Decompiled with CFR 0.152.
 */
package it.com.radiantminds.plugins.jira.lucene;

import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.issue.IssueService;
import com.atlassian.jira.bc.issue.worklog.WorklogInputParameters;
import com.atlassian.jira.bc.issue.worklog.WorklogInputParametersImpl;
import com.atlassian.jira.bc.issue.worklog.WorklogResult;
import com.atlassian.jira.bc.issue.worklog.WorklogService;
import com.atlassian.jira.config.IssueTypeManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.index.IssueIndexManager;
import com.atlassian.jira.issue.worklog.Worklog;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.rm.common.bridges.agile.customfields.AgileCustomFieldsServiceBridgeProxy;
import com.atlassian.rm.common.bridges.jira.issue.IssueServiceBridgeProxy;
import com.atlassian.rm.common.envtestutils.ProjectDefinition;
import com.atlassian.rm.common.envtestutils.WiredTestCase;
import com.atlassian.rm.common.envtestutils.WiredTestUtils;
import com.radiantminds.roadmap.common.extensions.workitems.WorkItemExtension;
import com.radiantminds.roadmap.jira.common.components.utils.customfields.CustomFieldsService;
import java.util.Date;

public abstract class BaseLuceneExtensionLinkDataTest
extends WiredTestCase {
    final IssueServiceBridgeProxy issueServiceBridgeVersionProxy;
    final AgileCustomFieldsServiceBridgeProxy agileCustomFieldsServiceBridgeProxy;
    final CustomFieldsService customFields;
    final IssueTypeManager issueTypeManager;
    final JiraAuthenticationContext authenticationContext;
    final IssueService issueService;
    final IssueIndexManager issueIndexManager;
    final WorklogService worklogService;
    final WorkItemExtension workItemExtension;

    public BaseLuceneExtensionLinkDataTest(IssueServiceBridgeProxy issueServiceBridgeVersionProxy, AgileCustomFieldsServiceBridgeProxy agileCustomFieldsServiceBridgeProxy, CustomFieldsService customFields, IssueTypeManager issueTypeManager, JiraAuthenticationContext authenticationContext, IssueService issueService, IssueIndexManager issueIndexManager, WorklogService worklogService, WorkItemExtension workItemExtension) {
        this.issueServiceBridgeVersionProxy = issueServiceBridgeVersionProxy;
        this.agileCustomFieldsServiceBridgeProxy = agileCustomFieldsServiceBridgeProxy;
        this.customFields = customFields;
        this.issueTypeManager = issueTypeManager;
        this.authenticationContext = authenticationContext;
        this.issueService = issueService;
        this.issueIndexManager = issueIndexManager;
        this.worklogService = worklogService;
        this.workItemExtension = workItemExtension;
    }

    Worklog createWorklog(Issue issue, String timeString) {
        JiraServiceContextImpl jiraServiceContext = new JiraServiceContextImpl(this.authenticationContext.getUser());
        WorklogInputParameters worklogInputParameters = WorklogInputParametersImpl.issue((Issue)issue).timeSpent(timeString).startDate(new Date()).build();
        WorklogResult createValidationResult = this.worklogService.validateCreate((JiraServiceContext)jiraServiceContext, worklogInputParameters);
        return this.worklogService.createAndAutoAdjustRemainingEstimate((JiraServiceContext)jiraServiceContext, createValidationResult, true);
    }

    protected static class LuceneExtensionTestProjectDefinition
    implements ProjectDefinition {
        private static final String PROJECT_KEY = "LETPD";

        protected LuceneExtensionTestProjectDefinition() {
        }

        public Project instantiate(WiredTestUtils utils) throws Exception {
            return utils.getProjectUtils().createStandardProject(utils.getUserUtils().getAdminUser(), PROJECT_KEY, PROJECT_KEY);
        }
    }

    protected static class LuceneExtensionTestProjectDefinitionScrum
    implements ProjectDefinition {
        private static final String PROJECT_KEY = "LETPDS";

        protected LuceneExtensionTestProjectDefinitionScrum() {
        }

        public Project instantiate(WiredTestUtils utils) throws Exception {
            return utils.getProjectUtils().createScrumProject(utils.getUserUtils().getAdminUser(), PROJECT_KEY, PROJECT_KEY);
        }
    }
}

