/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.analysis;

import com.atlassian.rm.jpo.scheduling.roadmap.analysis.BoundDiscreteStepFunction;
import com.atlassian.rm.jpo.scheduling.roadmap.analysis.IBoundedDiscreteStepFunction;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.solution.IWorkAssignment;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IResourceType;
import java.util.Set;
import javax.annotation.concurrent.Immutable;

@Immutable
class StepFunctionCreator {
    StepFunctionCreator() {
    }

    IBoundedDiscreteStepFunction addAmountsAfterEnd(Set<IResourceType> types, Set<IWorkAssignment> workAssignments, int endTime) {
        BoundDiscreteStepFunction function = new BoundDiscreteStepFunction(endTime);
        for (IWorkAssignment workAssignment : workAssignments) {
            IResourceType resourceType = workAssignment.getResourceType();
            if (!types.contains(resourceType)) continue;
            float amount = workAssignment.getAssignedWorkUnits();
            int end = workAssignment.getEnd();
            function.addBetween(end + 1, endTime, amount);
        }
        return function;
    }

    IBoundedDiscreteStepFunction addAmountsOnStart(Set<IResourceType> types, Set<IWorkAssignment> workAssignments, int endTime) {
        BoundDiscreteStepFunction function = new BoundDiscreteStepFunction(endTime);
        for (IWorkAssignment workAssignment : workAssignments) {
            IResourceType resourceType = workAssignment.getResourceType();
            if (!types.contains(resourceType)) continue;
            float amount = workAssignment.getAssignedWorkUnits();
            int start = workAssignment.getStart();
            function.addBetween(start, endTime, amount);
        }
        return function;
    }
}

