/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.jira.common.components.issues;

import com.radiantminds.roadmap.common.data.entities.common.IExtensionLink;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.workitem.AOWorkItem;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioExtensionLinkPersistence;
import java.sql.SQLException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JiraIssueLinkAccessor {
    public static final String JIRA_ISSUE_LINK_KEY = "jira-issue";
    public static final Pattern JIRA_ISSUE_STAGE_LINK_PATTERN = Pattern.compile("jira-issue-stage-(\\d+)");
    PortfolioExtensionLinkPersistence extensionLinkPersistence;

    public JiraIssueLinkAccessor(PortfolioExtensionLinkPersistence extensionLinkPersistence) {
        this.extensionLinkPersistence = extensionLinkPersistence;
    }

    public List<String> getWorkItemsForIssue(String issueKey) throws SQLException {
        return this.extensionLinkPersistence.getTargetIdsForLink(AOWorkItem.class, JIRA_ISSUE_LINK_KEY, issueKey);
    }

    public void removeAllLinksForIssue(String issueKey) throws SQLException {
        this.extensionLinkPersistence.removeAllExtensionLinks(JIRA_ISSUE_LINK_KEY, issueKey);
    }

    public static boolean isStageLink(IExtensionLink link) {
        Matcher matcher = JIRA_ISSUE_STAGE_LINK_PATTERN.matcher(link.getExtensionKey());
        return matcher.matches();
    }

    public static String getStageId(IExtensionLink link) {
        Matcher matcher = JIRA_ISSUE_STAGE_LINK_PATTERN.matcher(link.getExtensionKey());
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return null;
    }
}

