/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.common.bridges.agile.common.service;

import com.atlassian.greenhopper.service.ServiceResult;
import com.atlassian.rm.common.bridges.agile.AgileNotAvailableException;
import com.atlassian.rm.common.bridges.agile.AgileServiceOutcomeException;
import com.atlassian.rm.common.bridges.agile.service.AgileServiceOutcomeExceptionFactory;
import com.atlassian.rm.common.bridges.api.plugins.access.BundleServiceAccessor;
import com.atlassian.rm.common.bridges.api.plugins.access.BundleServiceAccessorProvider;
import com.atlassian.rm.common.bridges.api.plugins.access.ServiceCallback;

public class UnsafeBundleServiceServiceResultHandler {
    private final BundleServiceAccessorProvider bundleServiceAccessorProvider;
    private final String pluginKey;
    private final String componentKey;

    public UnsafeBundleServiceServiceResultHandler(BundleServiceAccessorProvider bundleServiceAccessorProvider, String pluginKey, String componentKey) {
        this.bundleServiceAccessorProvider = bundleServiceAccessorProvider;
        this.pluginKey = pluginKey;
        this.componentKey = componentKey;
    }

    public <TService, TServiceResult> void perform(final Action<TService, TServiceResult> action) throws AgileServiceOutcomeException, AgileNotAvailableException {
        try {
            BundleServiceAccessor serviceAccessor = this.bundleServiceAccessorProvider.createUnsafeServiceAccessor(this.pluginKey, this.componentKey);
            serviceAccessor.perform(new ServiceCallback<TService, Void>(){

                @Override
                public Void perform(TService service) throws Exception {
                    Object serviceResult = action.getServiceResult(service);
                    ServiceResult serviceResultCasted = (ServiceResult)serviceResult;
                    if (UnsafeBundleServiceServiceResultHandler.this.hasErrors(serviceResultCasted)) {
                        throw AgileServiceOutcomeExceptionFactory.createException(serviceResultCasted.getErrors());
                    }
                    return null;
                }
            });
        }
        catch (AgileServiceOutcomeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new AgileNotAvailableException(e);
        }
    }

    private boolean hasErrors(ServiceResult serviceResultCasted) {
        return serviceResultCasted.getErrors() != null && serviceResultCasted.getErrors().hasErrors();
    }

    public static interface Action<TService, TServiceResult> {
        public TServiceResult getServiceResult(TService var1);
    }
}

