/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.handlers;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.radiantminds.roadmap.common.data.entities.common.IIdentifiable;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.EntityInfo;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.IEntityPersistence;
import com.radiantminds.roadmap.common.data.persistence.services.PortfolioPlanPersistence;
import com.radiantminds.roadmap.common.handlers.BadDeveloperException;
import com.radiantminds.roadmap.common.handlers.EntityContextPreparationResult;
import com.radiantminds.roadmap.common.handlers.EntityIdentifier;
import com.radiantminds.roadmap.common.handlers.NotAuthorizedException;
import com.radiantminds.roadmap.common.permissions.PlanPermission;
import com.radiantminds.roadmap.common.permissions.PlanPermissionCheckResult;
import com.radiantminds.roadmap.common.permissions.PlanPermissions;
import com.radiantminds.roadmap.common.rest.common.ResponseBuilder;
import com.radiantminds.roadmap.common.rest.entities.common.ModificationResult;
import com.radiantminds.roadmap.common.rest.entities.common.RestBulkItemResult;
import com.radiantminds.roadmap.common.rest.entities.common.RestItemResult;
import com.radiantminds.roadmap.common.rest.entities.common.messaging.RestMessaging;
import java.sql.Connection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.ws.rs.core.Response;

public class BulkEntityContext<T extends IIdentifiable> {
    private final List<EntityIdentifier> entityIds;
    private final List<EntityIdentifier> validEntityIds;
    private final Long expectedPlanVersion;
    private Map<String, EntityInfo> indexedEntityInfos;
    private String planId;
    private Long planVersion;
    private IEntityPersistence<T> entityPersistence;
    private PortfolioPlanPersistence planPersistence;
    private boolean incrementEntityVersion;
    private boolean incrementPlanVersion;
    private Long incrementedPlanVersion;
    private boolean allowDynamicSchedulingVersionHandling;
    private boolean incrementSchedulingVersion;
    private Long incrementedSchedulingVersion;
    private final List<RestItemResult> resultEntries;

    private BulkEntityContext(List<EntityIdentifier> entityIds, Long expectedPlanVersion) {
        this.entityIds = entityIds;
        this.expectedPlanVersion = expectedPlanVersion;
        this.validEntityIds = Lists.newArrayList();
        this.resultEntries = Lists.newArrayList();
    }

    public List<EntityIdentifier> getEntityIds() {
        return this.validEntityIds;
    }

    public void setIncrementSchedulingVersion(boolean incrementSchedulingVersion) {
        if (!this.allowDynamicSchedulingVersionHandling) {
            throw new BadDeveloperException("Dear developer; though shall not set scheduling version handling dynamically unless the proper annotation value is used.");
        }
        this.incrementSchedulingVersion = incrementSchedulingVersion;
    }

    public void addSuccess(String workItemId) throws Exception {
        Long entityVersion = this.indexedEntityInfos.get(workItemId).getEntityVersion();
        if (this.incrementEntityVersion) {
            entityVersion = this.entityPersistence.incrementVersion(workItemId);
        }
        RestItemResult result = new RestItemResult(workItemId, new ModificationResult(entityVersion, workItemId));
        this.resultEntries.add(result);
    }

    public void addFail(String workItemId, String fail) {
        RestItemResult result = new RestItemResult(workItemId, fail);
        this.resultEntries.add(result);
    }

    @Deprecated
    public Response createResult() throws Exception {
        return this.createResult(null);
    }

    public Response createResult(Connection connection) throws Exception {
        if (this.incrementPlanVersion) {
            EntityInfo updatedEntityInfo = this.planPersistence.incrementVersions(connection, this.planId, this.incrementPlanVersion, this.incrementSchedulingVersion);
            this.incrementedPlanVersion = updatedEntityInfo.getPlanVersion();
            this.incrementedSchedulingVersion = updatedEntityInfo.getSchedulingVersion();
        }
        RestBulkItemResult allResults = new RestBulkItemResult();
        allResults.addResults(this.resultEntries);
        return ResponseBuilder.ok(this.expectedPlanVersion, this.planVersion, this.incrementedPlanVersion, this.incrementedSchedulingVersion, false, allResults);
    }

    EntityContextPreparationResult prepare(IEntityPersistence<T> entityPersistence, PortfolioPlanPersistence planPersistence, PlanPermissions planPermissionHandler, PlanPermission ... planPermissions) throws Exception {
        if (this.entityIds == null) {
            return EntityContextPreparationResult.createErrorResponse(planPermissionHandler, planPermissions, ResponseBuilder.badRequest(RestMessaging.error("No IDs provided for bulk operation.")));
        }
        this.entityPersistence = entityPersistence;
        this.planPersistence = planPersistence;
        List<EntityInfo> entityInfos = this.entityPersistence.getEntityInfos(Lists.newArrayList((Iterable)Iterables.transform(this.entityIds, EntityIdentifier.TO_ID_STRING_TRANSFORMATION)));
        if (entityInfos.size() > 0) {
            HashSet differentPlanIds = Sets.newHashSet((Iterable)Iterables.transform(entityInfos, EntityInfo.TO_PLAN_ID_STRING_TRANSFORMATION));
            if (differentPlanIds.size() > 1) {
                return EntityContextPreparationResult.createErrorResponse(planPermissionHandler, planPermissions, ResponseBuilder.badRequest(RestMessaging.error("Unsupported multi-plan bulk operation.")));
            }
            this.planId = entityInfos.get(0).getPlanId();
            PlanPermissionCheckResult planAuthentication = planPermissionHandler.check(this.planId, planPermissions);
            if (planAuthentication.isDenied()) {
                throw new NotAuthorizedException();
            }
            return EntityContextPreparationResult.createForBulk(planPermissionHandler, planPermissions, planAuthentication, entityInfos);
        }
        return EntityContextPreparationResult.createErrorResponse(planPermissionHandler, planPermissions, ResponseBuilder.badRequest(RestMessaging.entityNotFound()));
    }

    void init(EntityContextPreparationResult preparationResult, boolean incrementEntityVersion, boolean incrementPlanVersion, boolean incrementSchedulingVersion, boolean allowDynamicSchedulingVersionHandling) throws Exception {
        this.incrementEntityVersion = incrementEntityVersion;
        this.incrementPlanVersion = incrementPlanVersion;
        this.incrementSchedulingVersion = incrementSchedulingVersion;
        this.allowDynamicSchedulingVersionHandling = allowDynamicSchedulingVersionHandling;
        if (preparationResult.getEntityInfos().size() > 0) {
            EntityInfo firstEntityInfo = preparationResult.getEntityInfos().get(0);
            this.incrementedPlanVersion = this.planVersion = firstEntityInfo.getPlanVersion();
            this.incrementedSchedulingVersion = firstEntityInfo.getSchedulingVersion();
            this.indexedEntityInfos = Maps.uniqueIndex(preparationResult.getEntityInfos(), (Function)new Function<EntityInfo, String>(){

                public String apply(@Nullable EntityInfo entityInfo) {
                    return entityInfo.getEntityId();
                }
            });
            for (EntityIdentifier entityIdentifier : this.entityIds) {
                EntityInfo entityInfo = this.indexedEntityInfos.get(entityIdentifier.getId());
                if (entityInfo != null) {
                    if (entityIdentifier.getVersion() != null) {
                        if (!entityIdentifier.getVersion().equals(entityInfo.getEntityVersion())) {
                            this.addFail(entityIdentifier.getId(), "version-conflict");
                            continue;
                        }
                        this.validEntityIds.add(entityIdentifier);
                        continue;
                    }
                    this.validEntityIds.add(entityIdentifier);
                    continue;
                }
                this.addFail(entityIdentifier.getId(), "not-found");
            }
        }
    }

    @Deprecated
    public static BulkEntityContext from(List<? extends EntityIdentifier> entityIds) {
        return new BulkEntityContext(entityIds, null);
    }

    @Deprecated
    public static BulkEntityContext from(List<? extends EntityIdentifier> entityIds, Long expectedPlanVersion) {
        return new BulkEntityContext(entityIds, expectedPlanVersion);
    }
}

