/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.persistence.ao.entities.plans;

import com.atlassian.pocketknife.api.logging.Log;
import com.radiantminds.roadmap.common.data.activeobjects.ActiveObjectsUtilities;
import com.radiantminds.roadmap.common.data.entities.plans.IPlan;
import com.radiantminds.roadmap.common.data.entities.plans.IPlanConfiguration;
import com.radiantminds.roadmap.common.data.entities.releases.IStream;
import com.radiantminds.roadmap.common.data.persistence.PersistenceException;
import com.radiantminds.roadmap.common.data.persistence.PersistenceIndex;
import com.radiantminds.roadmap.common.data.persistence.ao.AOEntityPersistence;
import com.radiantminds.roadmap.common.data.persistence.ao.common.AOTransformer;
import com.radiantminds.roadmap.common.data.persistence.ao.common.TransformerUtils;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.permissions.sql.PermissionSQL;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.plans.AOPlan;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.plans.AOPlanConfiguration;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.plans.sql.InvalidPlanConfigurationException;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.plans.sql.PlanConfigurationSQL;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.plans.sql.PlanSQL;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.releases.AOStream;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.releases.PortfolioActiveObjectsStreamPersistence;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.solutions.sql.SolutionSQL;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.AOQueryGenerator;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.EntityInfo;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.IEntityPersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioStreamPersistence;
import com.radiantminds.roadmap.common.data.persistence.services.PortfolioPlanPersistence;
import com.radiantminds.roadmap.common.extensions.users.UserData;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PortfolioActiveObjectsPlanPersistence
extends AOEntityPersistence<IPlan, AOPlan>
implements PortfolioPlanPersistence {
    private static final Log LOGGER = Log.with(PortfolioActiveObjectsPlanPersistence.class);
    private final PermissionSQL permissionSQL;
    private final PlanSQL planSQL;
    private final SolutionSQL solutionSQL;
    private final PlanConfigurationSQL planConfigurationSQL;
    private final PersistenceIndex persistenceIndex;

    @Autowired
    public PortfolioActiveObjectsPlanPersistence(PersistenceIndex persistenceIndex, ActiveObjectsUtilities utils) {
        super(utils, IPlan.class, AOPlan.class);
        this.persistenceIndex = persistenceIndex;
        this.permissionSQL = new PermissionSQL(utils);
        this.planSQL = new PlanSQL(utils, this);
        this.planConfigurationSQL = new PlanConfigurationSQL(utils);
        this.solutionSQL = new SolutionSQL(utils);
    }

    @Override
    public Class<? extends IEntityPersistence> getPersistenceType() {
        return PortfolioPlanPersistence.class;
    }

    @Override
    protected void transform(IPlan source, AOPlan target) throws Exception {
        TransformerUtils.transformDescribable(source, target);
        target.setPlanVersion(source.getPlanVersion());
        target.setSchedulingVersion(source.getSchedulingVersion());
        target.setDate((Long)source.getDate().orNull());
        target.setReplanningDate((Long)source.getReplanningDate().orNull());
        target.setReplanningVersion(source.getReplanningVersion());
        target.setInReplanning(source.getInReplanning());
        target.setInStreamMode(source.getInStreamMode());
    }

    @Override
    public boolean delete(String id, boolean inCascade) throws PersistenceException {
        try {
            this.planConfigurationSQL.removePlanConfiguration(id);
        }
        catch (SQLException ex) {
            throw new PersistenceException("Failed to remove plan configuration for plan '" + id + "'", ex);
        }
        try {
            this.permissionSQL.removePermissionsForPlan(id);
        }
        catch (SQLException ex) {
            throw new PersistenceException("Failed to remove permissions for plan '" + id + "'", ex);
        }
        try {
            this.solutionSQL.removeSolutionsForPlan(id);
        }
        catch (SQLException ex) {
            throw new PersistenceException("Failed to remove solutions for plan '" + id + "'", ex);
        }
        return this.getUtils().delete(this.getEntityClass(), this.getAoClazz(), id);
    }

    @Override
    public void onAfterCreate(IPlan plan) throws PersistenceException {
        IStream stream = this.createDefaultReleaseStream(plan);
        PortfolioStreamPersistence streamPersistence = this.persistenceIndex.getBeanFromContext(PortfolioStreamPersistence.class);
        streamPersistence.onAfterCreate(stream);
        LOGGER.info("Initializing plan configuration...", new Object[0]);
        AOPlanConfiguration planConfiguration = (AOPlanConfiguration)this.getUtils().create(AOPlanConfiguration.class);
        planConfiguration.setAOPlan((AOPlan)plan);
        planConfiguration.save();
        LOGGER.info("Created plan configuration with for plan '%s", plan.getId());
    }

    @Override
    public IStream createDefaultReleaseStream(IPlan plan) throws PersistenceException {
        LOGGER.info("New plan created with identifier '%s', initializing default release stream...", plan.getId());
        IStream defaultReleaseStream = this.persistStream((IStream)this.getUtils().create(AOStream.class));
        defaultReleaseStream.setTitle("Default Stream");
        defaultReleaseStream.setShortName("D");
        defaultReleaseStream.setPlan(plan);
        defaultReleaseStream.setColor("#3b7fc4");
        defaultReleaseStream.setSortOrder(-1L);
        defaultReleaseStream.setVersion(0L);
        IStream stream = this.persistStream(defaultReleaseStream);
        LOGGER.info("Created default release stream with id '%s' for plan '%s'", stream.getId(), plan.getId());
        return stream;
    }

    @Override
    public void setReleaseMode(String planId, boolean inReleaseMode) throws SQLException {
        this.planSQL.setReleaseMode(planId, inReleaseMode);
    }

    private IStream persistStream(IStream stream) throws PersistenceException {
        return this.getUtils().persist(IStream.class, AOStream.class, stream, new AOTransformer<IStream, AOStream>(){

            @Override
            public void copyValues(IStream source, AOStream target) throws Exception {
                PortfolioActiveObjectsStreamPersistence.transformStream(source, target, PortfolioActiveObjectsPlanPersistence.this);
            }
        }, false);
    }

    @Override
    public EntityInfo getEntityInfo(String planId) throws SQLException {
        return this.planSQL.getEntityInfo(planId);
    }

    @Override
    public Long incrementPlanVersion(String planId) throws SQLException {
        this.planSQL.incrementPlanVersion(planId);
        EntityInfo entityInfo = this.planSQL.getEntityInfo(planId);
        if (entityInfo != null) {
            return entityInfo.getPlanVersion();
        }
        return null;
    }

    @Override
    public EntityInfo incrementVersions(Connection connection, String planId, boolean incrementPlanVersion, boolean incrementSchedulingVersion) throws SQLException {
        this.planSQL.incrementVersions(connection, planId, incrementPlanVersion, incrementSchedulingVersion);
        if (connection != null) {
            connection.commit();
        }
        return this.planSQL.getEntityInfo(planId);
    }

    @Override
    public IPlan getPlanWithCustomQuery(String planId, boolean includeReplanning) throws SQLException {
        return this.planSQL.getPlan(planId, includeReplanning);
    }

    @Override
    public List<IPlan> listPlansWithCustomQuery(boolean includeReplanning) throws Exception {
        return this.planSQL.getAllPlans(includeReplanning);
    }

    @Override
    public List<String> listAllAvailablePlanIds() throws Exception {
        return this.planSQL.listAllAvailablePlanIds();
    }

    @Override
    public Map<String, IPlan> listPlansWithPermission(UserData activeUserData) throws Exception {
        return this.planSQL.listPlansWithPermission(activeUserData);
    }

    @Override
    public void setPlanConfiguration(String planId, IPlanConfiguration config) throws SQLException, InvalidPlanConfigurationException {
        this.planConfigurationSQL.setPlanConfiguration(planId, config);
    }

    @Override
    public IPlanConfiguration getPlanConfiguration(String planId) throws SQLException {
        return this.planConfigurationSQL.getPlanConfiguration(planId);
    }

    @Override
    public void selectAllForPlan(AOQueryGenerator generator, String planId, boolean inOrder) throws SQLException {
        generator.withTable(AOPlan.class, "p").select().raw("*").from("p").where().colId("p").eq().numeric(planId);
        if (inOrder) {
            generator.orderBy().colId("p");
        }
    }
}

