/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct;

import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.IProcessingItemDependencyState;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.dep.IDependencyDefinition;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.IWorkSlot;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.processing.IProcessingStage;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.solution.IActivitySetSchedule;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.solution.IUnstructuredItemSchedule;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IActivitySet;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IProcessingItem;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IUnstructuredItem;
import com.atlassian.rm.jpo.scheduling.util.RmIdentifiableUtils;
import com.atlassian.rm.jpo.scheduling.util.RmUtils;
import com.google.common.base.Optional;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
class ProcessingItemCausalConstraintsState
implements IProcessingItemDependencyState {
    private final Map<String, Integer> releaseTimes;
    private final Map<String, Set<String>> openPrerequisites;
    private final Map<String, Set<String>> directSuccessors;
    private final Map<String, IProcessingItem> itemMap;

    ProcessingItemCausalConstraintsState(Map<String, Integer> releaseTimes, Map<String, Set<String>> openPrerequisite, Map<String, Set<String>> successorMap, Map<String, IProcessingItem> itemMap) {
        this.releaseTimes = releaseTimes;
        this.openPrerequisites = openPrerequisite;
        this.directSuccessors = successorMap;
        this.itemMap = itemMap;
    }

    @Override
    public Optional<Integer> getReleaseTime(IProcessingItem item) {
        if (!this.isEligible(item)) {
            return Optional.absent();
        }
        return Optional.of((Object)this.releaseTimes.get(item.getId()));
    }

    @Override
    public boolean isEligible(IProcessingItem processingItem) {
        Set<String> openPreds = this.openPrerequisites.get(processingItem.getId());
        if (openPreds == null) {
            return false;
        }
        return openPreds.isEmpty();
    }

    @Override
    public Set<IProcessingItem> getOpenTransitivePrerequisites(IProcessingItem item) {
        Set<String> set = this.openPrerequisites.get(item.getId());
        if (set == null) {
            return Sets.newHashSet();
        }
        return RmIdentifiableUtils.getElementsWithIds(set, this.itemMap);
    }

    @Override
    public void updateActivitySet(IActivitySetSchedule schedule) {
        IActivitySet activitySet = schedule.getActivitySet();
        this.processingItemEnded(activitySet.getId(), schedule.getEnd());
    }

    @Override
    public void updateUnstructuredItem(IUnstructuredItemSchedule schedule, IUnstructuredItem unstructuredItem, Optional<IUnstructuredItem> newUnstructuredItem) {
        int scheduleEnd = schedule.getEnd();
        if (schedule.isItemCompleted()) {
            this.processingItemEnded(schedule.getId(), scheduleEnd);
        } else {
            IUnstructuredItem newItem = (IUnstructuredItem)newUnstructuredItem.get();
            String itemId = schedule.getId();
            this.itemMap.put(itemId, newItem);
            IProcessingStage firstOpenStage = newItem.getWorkDemand().getSpecifiedStages().get(0);
            Optional<IProcessingStage> previousStage = unstructuredItem.getWorkDemand().getPreviousStage(firstOpenStage);
            if (previousStage.isPresent()) {
                Set<IWorkSlot> slots = schedule.getStageToWorkSlotsMap().get(previousStage.get());
                if (slots == null || slots.isEmpty()) {
                    this.releaseTimes.put(itemId, scheduleEnd + 1);
                } else {
                    int maxEnd = RmUtils.getMaxEnd(slots);
                    this.releaseTimes.put(itemId, maxEnd + 1);
                }
            }
        }
    }

    private void processingItemEnded(String id, int endTime) {
        this.releaseTimes.remove(id);
        this.openPrerequisites.remove(id);
        for (Set<String> openPreds : this.openPrerequisites.values()) {
            openPreds.remove(id);
        }
        Set<String> successors = this.directSuccessors.get(id);
        for (String successor : successors) {
            if (!this.releaseTimes.containsKey(successor)) {
                this.releaseTimes.put(successor, endTime + 1);
                continue;
            }
            this.releaseTimes.put(successor, Math.max(this.releaseTimes.get(successor), endTime + 1));
        }
    }

    public static ProcessingItemCausalConstraintsState createInstance(IDependencyDefinition dependencyDefinition) {
        HashMap releaseMap = Maps.newHashMap();
        HashMap openPredsMap = Maps.newHashMap();
        HashMap directSuccessors = Maps.newHashMap();
        for (IProcessingItem item : dependencyDefinition.getProcessingItems()) {
            Set<IProcessingItem> transitivePrerequisites = dependencyDefinition.getTransitivePrerequisites(item);
            if (transitivePrerequisites.isEmpty()) {
                releaseMap.put(item.getId(), 0);
            }
            openPredsMap.put(item.getId(), RmIdentifiableUtils.getIds(transitivePrerequisites));
            Set<IProcessingItem> successors = dependencyDefinition.getDirectDependees(item);
            directSuccessors.put(item.getId(), RmIdentifiableUtils.getIds(successors));
        }
        ProcessingItemCausalConstraintsState instance = new ProcessingItemCausalConstraintsState(releaseMap, openPredsMap, directSuccessors, (Map<String, IProcessingItem>)RmIdentifiableUtils.createIdMap(dependencyDefinition.getProcessingItems()));
        return instance;
    }
}

