/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.persistence.ao.sql;

import com.google.common.collect.Lists;
import com.radiantminds.roadmap.common.data.activeobjects.ActiveObjectsUtilities;
import com.radiantminds.roadmap.common.data.entities.common.IVersionable;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.AOQueryGenerator;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.BaseAOPersistenceSQL;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.statements.IQuery;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.statements.IUpdate;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class CommonSQL
extends BaseAOPersistenceSQL {
    public CommonSQL(ActiveObjectsUtilities activeObjectsUtilities) {
        super(activeObjectsUtilities);
    }

    public <TTable extends IVersionable> void incrementVersion(final Class<TTable> tableClazz, final String id) throws SQLException {
        this.sql(new IUpdate(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.withTable(tableClazz, "t").update().tableNoAlias("t").set().colNoAlias("t", "version").eq().raw("(coalesce(").colNoAlias("t", "version").raw(",0) + 1)").where().colIdNoAlias("t").eq().numeric(id);
            }
        });
    }

    public <TTable extends IVersionable> Boolean exists(final Class<TTable> tableClazz, final String id) throws SQLException {
        return this.sql(new IQuery<Boolean>(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.withTable(tableClazz, "t").select().colId("t").from("t").where().colId("t").eq().numeric(id);
            }

            @Override
            public Boolean handleResult(ResultSet result) throws Exception {
                if (result.next()) {
                    return true;
                }
                return false;
            }
        });
    }

    public <TTable extends IVersionable> List<String> existingSubset(final Class<TTable> tableClazz, final List<String> ids) throws SQLException {
        return this.sql(new IQuery<List<String>>(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.withTable(tableClazz, "t").select().colId("t").from("t").where().inNumeric(new AOQueryGenerator.InOperandCallback(){

                    @Override
                    public void generateOperand(AOQueryGenerator generator) {
                        generator.colId("t");
                    }
                }, ids);
            }

            @Override
            public List<String> handleResult(ResultSet result) throws Exception {
                ArrayList retVal = Lists.newArrayList();
                while (result.next()) {
                    retVal.add(BaseAOPersistenceSQL.getString(result, 1));
                }
                return retVal;
            }
        });
    }

    public <TTable extends IVersionable> Long getVersion(final Class<TTable> tableClazz, final String id) throws SQLException {
        return this.sql(new IQuery<Long>(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.withTable(tableClazz, "t").select().col("t", "version").from("t").where().colId("t").eq().numeric(id);
            }

            @Override
            public Long handleResult(ResultSet result) throws Exception {
                if (result.next()) {
                    return BaseAOPersistenceSQL.getLong(result, 1);
                }
                return null;
            }
        });
    }
}

