/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.problem;

import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.annotation.IScheduleViolation;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.annotation.IScheduleWarning;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.IResourceGroup;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.problem.IRoadmapProblem;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.processing.IProcessingDefinition;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.time.ITimePlan;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IBacklog;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IRoadmapProblemStatistics;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.RoadmapProblemStatistics;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Set;
import javax.annotation.concurrent.Immutable;

@Immutable
public class DefaultRoadmapProblem
implements IRoadmapProblem {
    private final IBacklog backlog;
    private final Set<IResourceGroup> resourceGroups;
    private final ITimePlan timePlan;
    private final IProcessingDefinition processingDefinition;
    private final IRoadmapProblemStatistics statistics;

    public DefaultRoadmapProblem(IBacklog backlog, Set<IResourceGroup> resourceGroups, ITimePlan timePlan, IProcessingDefinition processingDefinition) {
        this(backlog, resourceGroups, timePlan, processingDefinition, RoadmapProblemStatistics.createInstance(Sets.newHashSet(backlog.getProcessingItems()), resourceGroups));
    }

    public DefaultRoadmapProblem(IBacklog backlog, Set<IResourceGroup> resourceGroups, ITimePlan timePlan, IProcessingDefinition processingDefinition, IRoadmapProblemStatistics statistics) {
        Preconditions.checkNotNull((Object)backlog, (Object)"backlog must not be null");
        Preconditions.checkNotNull(resourceGroups, (Object)"resource groups must not be null");
        Preconditions.checkNotNull((Object)timePlan, (Object)"time plan definition must not be null");
        Preconditions.checkNotNull((Object)processingDefinition, (Object)"processing definition must not be null");
        Preconditions.checkNotNull((Object)statistics, (Object)"roadmap statistics must not be null");
        this.backlog = backlog;
        this.resourceGroups = Collections.unmodifiableSet(resourceGroups);
        this.timePlan = timePlan;
        this.processingDefinition = processingDefinition;
        this.statistics = statistics;
    }

    @Override
    public IBacklog getBacklog() {
        return this.backlog;
    }

    @Override
    public Set<IResourceGroup> getResourceGroups() {
        return this.resourceGroups;
    }

    @Override
    public ITimePlan getTimePlan() {
        return this.timePlan;
    }

    @Override
    public IProcessingDefinition getProcessingDefinition() {
        return this.processingDefinition;
    }

    @Override
    public Set<IScheduleViolation> getViolations() {
        return this.backlog.getViolations();
    }

    @Override
    public Set<IScheduleWarning> getWarnings() {
        return this.backlog.getWarnings();
    }

    @Override
    public IRoadmapProblemStatistics getRoadmapStatistics() {
        return this.statistics;
    }
}

