/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.persistence.ao.port.legacy.modifiers;

import com.google.common.base.Optional;
import com.google.common.collect.Maps;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.plans.AOPlan;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.releases.AORelease;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.releases.AOStream;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.workitem.AOWorkItem;
import com.radiantminds.roadmap.common.data.persistence.ao.port.AOTableImportData;
import com.radiantminds.roadmap.common.data.persistence.ao.port.legacy.BaseLegacyDocumentModifier;
import com.radiantminds.roadmap.common.utils.JPOVersion;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Component;

@Component
public class ReleaseStreamLegacyModifier
extends BaseLegacyDocumentModifier {
    @Override
    public JPOVersion isRelevantBeforeVersion() {
        return new JPOVersion(1, 2, 0);
    }

    @Override
    public void modify(List<AOTableImportData> importData) {
        Optional<AOTableImportData> planData = this.getDataFor(AOPlan.class, importData);
        Optional<AOTableImportData> releaseData = this.getDataFor(AORelease.class, importData);
        Optional<AOTableImportData> workItemData = this.getDataFor(AOWorkItem.class, importData);
        if (!(planData.isPresent() && releaseData.isPresent() && workItemData.isPresent())) {
            return;
        }
        Map<String, String> plan = ((AOTableImportData)planData.get()).getRows().get(0);
        String planId = plan.get("id");
        plan.put("instreammode", "false");
        AOTableImportData streamData = new AOTableImportData(AOStream.class, "streamCollection");
        HashMap defaultStreamRow = Maps.newHashMap();
        defaultStreamRow.put("aoplan", planId);
        defaultStreamRow.put("id", "1");
        defaultStreamRow.put("orderrangeidentifier", "plan-" + planId);
        defaultStreamRow.put("title", "Default Stream");
        defaultStreamRow.put("color", "#3b7fc4");
        defaultStreamRow.put("shortname", "D");
        streamData.addRow(defaultStreamRow);
        importData.add(streamData);
        for (Map<String, String> releaseRow : ((AOTableImportData)releaseData.get()).getRows()) {
            releaseRow.remove("aoplan");
            releaseRow.put("aostream", "1");
            releaseRow.put("orderrangeidentifier", "stream-1");
        }
        for (Map<String, String> workItemRow : ((AOTableImportData)workItemData.get()).getRows()) {
            workItemRow.put("aostream", "1");
        }
    }
}

