/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.scheduling.trafo.teams;

import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.IResourceGroup;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Sets;
import com.radiantminds.roadmap.common.data.entities.people.SchedulingTeam;
import com.radiantminds.roadmap.common.data.entities.plans.SchedulingPlan;
import com.radiantminds.roadmap.common.scheduling.trafo.settings.IResourceTypeMapping;
import com.radiantminds.roadmap.common.scheduling.trafo.teams.TeamTransformationResult;
import com.radiantminds.roadmap.common.scheduling.trafo.teams.TeamsTransformationResult;
import com.radiantminds.roadmap.common.scheduling.trafo.teams.TeamsTransformer;
import java.util.HashSet;

abstract class BaseTeamsTransformer
implements TeamsTransformer {
    private static final Log LOGGER = Log.with(BaseTeamsTransformer.class);

    BaseTeamsTransformer() {
    }

    @Override
    public TeamsTransformationResult createResourceGroups(SchedulingPlan plan, IResourceTypeMapping resourceTypeMapping) {
        LOGGER.debug("create resource group for teams: %s", Joiner.on((String)",").join(plan.getTeams()));
        HashBiMap biMap = HashBiMap.create();
        HashSet ignoredTeams = Sets.newHashSet();
        for (SchedulingTeam schedulingTeam : plan.getTeams()) {
            Optional<IResourceGroup> resourceGroup = this.tryGetResourceGroup(resourceTypeMapping, schedulingTeam, plan);
            if (resourceGroup.isPresent()) {
                biMap.put((Object)schedulingTeam, resourceGroup.get());
                continue;
            }
            ignoredTeams.add(schedulingTeam);
        }
        LOGGER.debug("created resource groups : %s", Joiner.on((String)",").join((Iterable)biMap.values()));
        TeamTransformationResult result = new TeamTransformationResult((BiMap<SchedulingTeam, IResourceGroup>)biMap, ignoredTeams);
        return result;
    }

    protected abstract Optional<IResourceGroup> tryGetResourceGroup(IResourceTypeMapping var1, SchedulingTeam var2, SchedulingPlan var3);
}

