/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.jira.common.components.utils;

import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.pocketknife.api.logging.Log;
import com.google.common.collect.Lists;
import com.radiantminds.roadmap.common.handlers.common.violations.ViolationMessage;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class JiraErrorCollectionUtil {
    private static final Log LOGGER = Log.with(JiraErrorCollectionUtil.class);

    public static List<ViolationMessage> handleValidationErrors(ErrorCollection validationErrors) {
        ArrayList messages = Lists.newArrayList();
        for (String string : validationErrors.getErrorMessages()) {
            messages.add(new ViolationMessage.Impl("raw", string));
            LOGGER.warn(string, new Object[0]);
        }
        for (ErrorCollection.Reason reason : validationErrors.getReasons()) {
            LOGGER.warn(MessageFormat.format("{0}; {1}; {2}", reason.getHttpStatusCode(), reason.name(), reason.toString()), new Object[0]);
        }
        for (Map.Entry entry : validationErrors.getErrors().entrySet()) {
            messages.add(new ViolationMessage.Impl("raw", (String)entry.getValue()));
            LOGGER.warn("%s: %s", entry.getKey(), entry.getValue());
        }
        if (messages.size() <= 0) {
            messages.add(new ViolationMessage.Impl("warning", "sync-item-not-updated"));
        }
        return messages;
    }
}

