/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.common.bridges.lucene;

import com.atlassian.rm.common.bridges.lucene.Field;
import com.atlassian.rm.common.bridges.lucene.LuceneConstants;
import org.apache.lucene.document.DoublePoint;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;

public class Field73
implements Field {
    private final IndexableField indexableField;
    private final Field.Configuration configuration;

    Field73(IndexableField indexableField, Field.Configuration configuration) {
        this.indexableField = indexableField;
        this.configuration = configuration;
    }

    IndexableField getLuceneValue() {
        return this.indexableField;
    }

    Field.Configuration getConfiguration() {
        return this.configuration;
    }

    @Override
    public String getName() {
        return this.indexableField.name();
    }

    @Override
    public String getStringValue() {
        return this.indexableField.stringValue();
    }

    public static class Factory
    implements Field.Factory {
        @Override
        public Field createTextField(String name, String value, Field.Configuration configuration) {
            FieldType fieldType = configuration.isAnalyzed() ? new FieldType((IndexableFieldType)(configuration.isStored() ? TextField.TYPE_STORED : TextField.TYPE_NOT_STORED)) : new FieldType((IndexableFieldType)(configuration.isStored() ? StringField.TYPE_STORED : StringField.TYPE_NOT_STORED));
            fieldType.setOmitNorms(configuration.isOmitNorms());
            return new Field73((IndexableField)new org.apache.lucene.document.Field(name, value, (IndexableFieldType)fieldType), configuration);
        }

        @Override
        public Field createBooleanField(String name, boolean value) {
            return this.createTextField(name, LuceneConstants.valueOf(value), Field.StandardConfigurations.NOT_ANALYZED);
        }

        @Override
        public Field createNumericField(String name, long value) {
            return new Field73((IndexableField)new LongPoint(name, new long[]{value}), Field.StandardConfigurations.ANALYZED);
        }

        @Override
        public Field createNumericField(String name, double value) {
            return new Field73((IndexableField)new DoublePoint(name, new double[]{value}), Field.StandardConfigurations.ANALYZED);
        }
    }
}

