/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.common.bridges.api.plugins.access;

import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.rm.common.bridges.api.plugins.access.BundleServiceAccessor;
import com.atlassian.rm.common.bridges.api.plugins.access.ServiceCallback;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

class DefaultBundleServiceAccessor<T>
implements BundleServiceAccessor<T> {
    private static final Log LOGGER = Log.with(DefaultBundleServiceAccessor.class);
    private final BundleContext bundleContext;
    private final String clazzName;

    public DefaultBundleServiceAccessor(BundleContext bundleContext, String clazzName) {
        this.bundleContext = bundleContext;
        this.clazzName = clazzName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <U> U perform(ServiceCallback<T, U> callback) throws Exception {
        Class<T> clazz = this.getClazz();
        ServiceReference reference = this.bundleContext.getServiceReference(this.clazzName);
        U retVal = null;
        try {
            Object serviceObject = this.bundleContext.getService(reference);
            T service = clazz.cast(serviceObject);
            retVal = callback.perform(service);
        }
        finally {
            this.bundleContext.ungetService(reference);
        }
        return retVal;
    }

    private Class<T> getClazz() {
        try {
            return this.getClass().getClassLoader().loadClass(this.clazzName);
        }
        catch (ClassNotFoundException ex) {
            LOGGER.warn(String.format("Class '%s' cannot be loaded. Containing bundle not available.", this.clazzName), new Object[0]);
            return null;
        }
        catch (Exception ex) {
            LOGGER.warn(String.format("Class '%s' cannot be loaded. Unknown cause.", this.clazzName), new Object[0]);
            LOGGER.exception(ex, Log.LogLevel.WARN);
            return null;
        }
    }

    public static <T> DefaultBundleServiceAccessor<T> createServiceAccessor(BundleContext bundleContext, Class<T> clazz) {
        return DefaultBundleServiceAccessor.createServiceAccessor(bundleContext, clazz.getName());
    }

    public static <T> DefaultBundleServiceAccessor<T> createServiceAccessor(BundleContext bundleContext, String clazzName) {
        DefaultBundleServiceAccessor<T> serviceAccessor = new DefaultBundleServiceAccessor<T>(bundleContext, clazzName);
        return serviceAccessor;
    }
}

