/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.common.bridges.jira.issue;

import com.atlassian.jira.config.SubTaskManager;
import com.atlassian.jira.exception.CreateException;
import com.atlassian.jira.exception.RemoveException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.util.IssueUpdateBean;
import com.atlassian.jira.issue.util.IssueUpdater;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.rm.common.bridges.api.SupportedVersions;
import com.atlassian.rm.common.bridges.jira.issue.SubtaskManagerBridge;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="com.atlassian.rm.common.bridges.jira.issue.SubtaskManagerBridgeImpl")
@SupportedVersions(all=true)
public class SubtaskManagerBridgeImpl
implements SubtaskManagerBridge {
    private final JiraAuthenticationContext authenticationContext;
    private final SubTaskManager subTaskManager;
    private final IssueUpdater issueUpdater;

    @Autowired
    SubtaskManagerBridgeImpl(JiraAuthenticationContext authenticationContext, SubTaskManager subTaskManager, IssueUpdater issueUpdater) {
        this.authenticationContext = authenticationContext;
        this.subTaskManager = subTaskManager;
        this.issueUpdater = issueUpdater;
    }

    @Override
    public void createSubTaskIssueLink(Issue parent, Issue subtask) throws CreateException {
        this.subTaskManager.createSubTaskIssueLink(parent, subtask, this.authenticationContext.getLoggedInUser());
    }

    @Override
    public void changeParent(Issue subTask, Issue newParentTask) throws RemoveException, CreateException {
        IssueUpdateBean updateBean = this.subTaskManager.changeParent(subTask, newParentTask, this.authenticationContext.getLoggedInUser());
        this.issueUpdater.doUpdate(updateBean, false);
    }
}

