/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.common.bridges.lucene.collectors;

import com.atlassian.rm.common.bridges.lucene.collectors.FirstPassGroupingCollector73;
import com.atlassian.rm.common.bridges.lucene.collectors.FirstPassGroupingResult;
import com.atlassian.rm.common.bridges.lucene.collectors.UnsortedFirstPassGroupingResult;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Set;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedDocValues;

public class AllGroupsFirstPassGroupCollector73
extends FirstPassGroupingCollector73 {
    private final String groupField;
    private final Set<String> groupValues;
    private LeafReader leafReader;
    private SortedDocValues docValues;

    public AllGroupsFirstPassGroupCollector73(String groupField) {
        this.groupField = groupField;
        this.groupValues = Sets.newHashSet();
    }

    protected void doSetNextReader(LeafReaderContext context) throws IOException {
        this.leafReader = context.reader();
        this.docValues = DocValues.getSorted((LeafReader)this.leafReader, (String)this.groupField);
    }

    public void collect(int doc) throws IOException {
        int ord;
        if (doc >= 0 && doc < this.leafReader.maxDoc() && this.docValues.advanceExact(doc) && (ord = this.docValues.ordValue()) >= 0) {
            this.groupValues.add(this.docValues.lookupOrd(ord).utf8ToString());
        }
    }

    public boolean needsScores() {
        return false;
    }

    @Override
    public FirstPassGroupingResult getResult() {
        return new UnsortedFirstPassGroupingResult(this.groupValues);
    }
}

