/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.heuristics.activity;

import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.heuristics.activity.ActivityAssignmentProblem;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.heuristics.activity.IndexedResourceSkillVariable;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.util.HasIndex;
import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class ActivityAssignmentProblemVariables {
    private final ActivityAssignmentProblem problem;
    private final List<IndexedResourceSkillVariable> variables;

    ActivityAssignmentProblemVariables(ActivityAssignmentProblem problem, List<IndexedResourceSkillVariable> variables) {
        this.problem = problem;
        this.variables = variables;
    }

    List<IndexedResourceSkillVariable> getVariables() {
        return this.variables;
    }

    static ActivityAssignmentProblemVariables from(ActivityAssignmentProblem problem) {
        return new ActivityAssignmentProblemVariables(problem, ActivityAssignmentProblemVariables.createVariables(problem));
    }

    private static List<IndexedResourceSkillVariable> createVariables(ActivityAssignmentProblem problem) {
        ArrayList wrappedVariables = Lists.newArrayListWithCapacity((int)problem.getVariableCount());
        for (int i = 0; i < problem.getVariableCount(); ++i) {
            wrappedVariables.add(new IndexedResourceSkillVariable(problem.getVariables().get(i), i));
        }
        return wrappedVariables;
    }

    int getResources() {
        return this.problem.getResources();
    }

    int getSkills() {
        return this.problem.getSkills();
    }

    Set<? extends HasIndex> getSkillVariables(final int s) {
        return Sets.filter((Set)Sets.newHashSet(this.variables), (Predicate)new Predicate<IndexedResourceSkillVariable>(){

            public boolean apply(IndexedResourceSkillVariable variable) {
                return variable.getSkill() == s;
            }
        });
    }

    double getDemand(int s) {
        return this.problem.getDemand(s);
    }

    int getVariableCount() {
        return this.variables.size();
    }

    Set<? extends HasIndex> getResourceVariables(final int r) {
        return Sets.filter((Set)Sets.newHashSet(this.variables), (Predicate)new Predicate<IndexedResourceSkillVariable>(){

            public boolean apply(IndexedResourceSkillVariable variable) {
                return variable.getResource() == r;
            }
        });
    }

    double getAvailability(int r) {
        return this.problem.getAvailability(r);
    }
}

