/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.heuristics.activity;

import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.heuristics.activity.ActivityAssignmentProblem;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.heuristics.activity.ActivityAssignmentProblemVariables;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.heuristics.activity.ActivityAssignmentSolution;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.heuristics.activity.ActivityAssignmentSolver;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.heuristics.activity.DefaultActivityAssignmentSolution;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.math.lp.LpLogging;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.util.ApacheUtils;
import com.atlassian.rm.jpo.scheduling.util.RmUtils;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.math3.optim.OptimizationData;
import org.apache.commons.math3.optim.PointValuePair;
import org.apache.commons.math3.optim.linear.LinearConstraint;
import org.apache.commons.math3.optim.linear.LinearConstraintSet;
import org.apache.commons.math3.optim.linear.LinearObjectiveFunction;
import org.apache.commons.math3.optim.linear.NoFeasibleSolutionException;
import org.apache.commons.math3.optim.linear.NonNegativeConstraint;
import org.apache.commons.math3.optim.linear.Relationship;
import org.apache.commons.math3.optim.linear.SimplexSolver;
import org.apache.commons.math3.optim.nonlinear.scalar.GoalType;

public class ActivityAssignmentSolverApacheImpl
implements ActivityAssignmentSolver {
    private static final Log LOGGER = Log.with(ActivityAssignmentSolverApacheImpl.class);
    private static final double DEFAULT_EPSILON = 0.001;
    private final SimplexSolver simplexSolver = new SimplexSolver(0.001);

    @Override
    public Optional<ActivityAssignmentSolution> solveWithoutOverbooking(ActivityAssignmentProblem problem) {
        try {
            LOGGER.debug("solve problem: %s", problem);
            ActivityAssignmentProblemVariables variables = ActivityAssignmentProblemVariables.from(problem);
            OptimizationData[] optData = ActivityAssignmentSolverApacheImpl.transform(variables);
            LpLogging.logDebug(optData);
            PointValuePair simplexSolution = this.simplexSolver.optimize(optData);
            DefaultActivityAssignmentSolution solution = DefaultActivityAssignmentSolution.create(RmUtils.toFloatArray(simplexSolution.getPoint()), variables);
            LOGGER.debug("found solution: %s", solution);
            return Optional.of((Object)solution);
        }
        catch (NoFeasibleSolutionException e) {
            LOGGER.debug("no feasible solution found", new Object[0]);
            return Optional.absent();
        }
    }

    private static OptimizationData[] transform(ActivityAssignmentProblemVariables variables) {
        ArrayList optData = Lists.newArrayList();
        optData.add(GoalType.MAXIMIZE);
        optData.add(ActivityAssignmentSolverApacheImpl.createObjectiveFunction(variables));
        optData.add(ActivityAssignmentSolverApacheImpl.createLinearConstraints(variables));
        optData.add(new NonNegativeConstraint(true));
        return optData.toArray(new OptimizationData[optData.size()]);
    }

    private static OptimizationData createLinearConstraints(ActivityAssignmentProblemVariables problem) {
        ArrayList constraints = Lists.newArrayList();
        constraints.addAll(ActivityAssignmentSolverApacheImpl.createAvailabilityConstraintSet(problem));
        constraints.addAll(ActivityAssignmentSolverApacheImpl.createStrictOpenSkillConstraintSet(problem));
        return new LinearConstraintSet(constraints);
    }

    private static List<LinearConstraint> createStrictOpenSkillConstraintSet(ActivityAssignmentProblemVariables problem) {
        ArrayList constraints = Lists.newArrayList();
        for (int s = 0; s < problem.getSkills(); ++s) {
            constraints.add(new LinearConstraint(ApacheUtils.createSetCoefficients(problem.getSkillVariables(s), problem.getVariableCount()), Relationship.EQ, problem.getDemand(s)));
        }
        return constraints;
    }

    private static List<LinearConstraint> createAvailabilityConstraintSet(ActivityAssignmentProblemVariables problem) {
        ArrayList constraints = Lists.newArrayList();
        for (int r = 0; r < problem.getResources(); ++r) {
            constraints.add(new LinearConstraint(ApacheUtils.createSetCoefficients(problem.getResourceVariables(r), problem.getVariableCount()), Relationship.LEQ, problem.getAvailability(r)));
        }
        return constraints;
    }

    private static OptimizationData createObjectiveFunction(ActivityAssignmentProblemVariables problem) {
        double[] coefficients = new double[problem.getVariables().size()];
        for (int i = 0; i < coefficients.length; ++i) {
            coefficients[i] = 1.0;
        }
        return new LinearObjectiveFunction(coefficients, 0.0);
    }
}

