/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.heuristics.activity;

import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.heuristics.activity.ActivityAssignmentProblem;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.heuristics.activity.IndexedOverbookableResourceSkillVariable;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.util.HasIndex;
import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class OverbookedActivityAssignmentProblemVariables {
    private final ActivityAssignmentProblem problem;
    private final List<IndexedOverbookableResourceSkillVariable> variables;

    private OverbookedActivityAssignmentProblemVariables(ActivityAssignmentProblem problem, List<IndexedOverbookableResourceSkillVariable> variables) {
        this.problem = problem;
        this.variables = variables;
    }

    List<IndexedOverbookableResourceSkillVariable> getVariables() {
        return this.variables;
    }

    static OverbookedActivityAssignmentProblemVariables create(ActivityAssignmentProblem problem) {
        return new OverbookedActivityAssignmentProblemVariables(problem, OverbookedActivityAssignmentProblemVariables.createVariables(problem));
    }

    private static List<IndexedOverbookableResourceSkillVariable> createVariables(ActivityAssignmentProblem problem) {
        ArrayList wrappedVariables = Lists.newArrayListWithCapacity((int)problem.getVariableCount());
        for (int i = 0; i < problem.getVariableCount(); ++i) {
            wrappedVariables.add(new IndexedOverbookableResourceSkillVariable(problem.getVariables().get(i), wrappedVariables.size(), true));
            wrappedVariables.add(new IndexedOverbookableResourceSkillVariable(problem.getVariables().get(i), wrappedVariables.size(), false));
        }
        return wrappedVariables;
    }

    int getResources() {
        return this.problem.getResources();
    }

    int getSkills() {
        return this.problem.getSkills();
    }

    Set<? extends HasIndex> getSkillVariables(final int s) {
        return Sets.filter((Set)Sets.newHashSet(this.variables), (Predicate)new Predicate<IndexedOverbookableResourceSkillVariable>(){

            public boolean apply(IndexedOverbookableResourceSkillVariable variable) {
                return variable.getSkill() == s;
            }
        });
    }

    double getDemand(int s) {
        return this.problem.getDemand(s);
    }

    int getVariableCount() {
        return this.variables.size();
    }

    Set<? extends HasIndex> getResourceVariables(final int r) {
        return Sets.filter((Set)Sets.newHashSet(this.variables), (Predicate)new Predicate<IndexedOverbookableResourceSkillVariable>(){

            public boolean apply(IndexedOverbookableResourceSkillVariable variable) {
                return variable.getResource() == r && !variable.isOverbookVariable();
            }
        });
    }

    double getAvailability(int r) {
        return this.problem.getAvailability(r);
    }

    Set<IndexedOverbookableResourceSkillVariable> getOverbookWorkVariables() {
        return Sets.filter((Set)Sets.newHashSet(this.variables), (Predicate)new Predicate<IndexedOverbookableResourceSkillVariable>(){

            public boolean apply(IndexedOverbookableResourceSkillVariable variable) {
                return variable.isOverbookVariable();
            }
        });
    }

    Set<IndexedOverbookableResourceSkillVariable> getNonOverbookWorkVariables() {
        return Sets.filter((Set)Sets.newHashSet(this.variables), (Predicate)new Predicate<IndexedOverbookableResourceSkillVariable>(){

            public boolean apply(IndexedOverbookableResourceSkillVariable variable) {
                return !variable.isOverbookVariable();
            }
        });
    }
}

