/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.assignment;

import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.common.IMutableResource;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.common.IMutableResourceGroup;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.common.IMutableResourcePool;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.common.SubsetSelectionPool;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.assignment.BaseSingleGroupAssignmentRestriction;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.assignment.IResourcePool;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.assignment.ResourcePool;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.IResourceGroup;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.resources.IWorkResource;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.math.AssignmentResource;
import com.atlassian.rm.jpo.scheduling.util.RmIdentifiableUtils;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Set;
import javax.annotation.concurrent.Immutable;

@Immutable
public class ResourceSelectionAssignmentRestriction
extends BaseSingleGroupAssignmentRestriction {
    private final IResourceGroup resourceGroup;
    private final Set<IWorkResource> selectedResources;
    private final Set<String> selectedResourceIds;

    public ResourceSelectionAssignmentRestriction(IResourceGroup resourceGroup, Set<IWorkResource> selectedResources) {
        super(resourceGroup);
        this.resourceGroup = (IResourceGroup)Preconditions.checkNotNull((Object)resourceGroup, (Object)"resource group must not be null");
        this.selectedResources = Collections.unmodifiableSet(selectedResources);
        this.selectedResourceIds = Collections.unmodifiableSet(RmIdentifiableUtils.getIds(selectedResources));
    }

    public ResourceSelectionAssignmentRestriction(IResourceGroup resourceGroup, Set<IWorkResource> selectedResources, int workSlotIndex) {
        super(workSlotIndex, resourceGroup);
        this.resourceGroup = (IResourceGroup)Preconditions.checkNotNull((Object)resourceGroup, (Object)"resource group must not be null");
        this.selectedResources = Collections.unmodifiableSet(selectedResources);
        this.selectedResourceIds = Collections.unmodifiableSet(RmIdentifiableUtils.getIds(selectedResources));
    }

    @Override
    public Set<IMutableResourcePool> filterMutableResourcePools(Set<IMutableResourceGroup> mutableResourceGroups) {
        IMutableResourceGroup mutableGroup = (IMutableResourceGroup)RmIdentifiableUtils.tryFindElementWithId(this.resourceGroup.getId(), mutableResourceGroups).get();
        Set<IMutableResource> mutableResources = RmIdentifiableUtils.getElementsWithIds(this.selectedResourceIds, mutableGroup.getMutableResources());
        SubsetSelectionPool pool = new SubsetSelectionPool(mutableGroup, mutableResources);
        return Sets.newHashSet((Object[])new IMutableResourcePool[]{pool});
    }

    @Override
    public Set<IResourcePool> getResourcePools() {
        ResourcePool pool = new ResourcePool(this.resourceGroup, this.selectedResources);
        return Sets.newHashSet((Object[])new IResourcePool[]{pool});
    }

    @Override
    public Set<AssignmentResource> filterResources(Set<AssignmentResource> skillRelevantResources) {
        return RmIdentifiableUtils.getElementsWithIds(this.selectedResourceIds, skillRelevantResources);
    }

    @Override
    public Set<IWorkResource> getResources() {
        return this.selectedResources;
    }

    public String toString() {
        return "ResourceSelectionAssignmentRestriction{selectedResourceIds=" + Joiner.on((String)",").join(this.selectedResourceIds) + "slotIndex=" + this.getWorkSlotIndex().orNull() + '}';
    }
}

