/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.math;

import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.actset.act.StageTaskProblem;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.math.AssignmentProblemSolution;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.math.AssignmentResource;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.math.BoundAssignmentProblem;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.math.ResourceAssignmentImpl;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.math.TemporalResourceAssignment;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.math.VariableAvailabilityState;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.math.search.AssignmentCandidate;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.math.search.AssignmentCandidateSolution;
import com.atlassian.rm.jpo.scheduling.util.SortableId;
import com.atlassian.rm.jpo.scheduling.util.collection.MutablePositivePrimitivesMap;
import com.atlassian.rm.jpo.scheduling.util.collection.PositivePrimitivesMap;
import com.atlassian.rm.jpo.scheduling.util.collection.RmCollectionUtils;
import com.atlassian.rm.jpo.scheduling.util.collection.SortedPositivePrimitiveMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

class AssignmentProblemSolutionImpl
implements AssignmentProblemSolution {
    private final ImmutableSet<TemporalResourceAssignment> assignments;

    AssignmentProblemSolutionImpl(Set<TemporalResourceAssignment> assignments) {
        this.assignments = ImmutableSet.copyOf(assignments);
    }

    @Override
    public Set<TemporalResourceAssignment> getAssignments() {
        return this.assignments;
    }

    static AssignmentProblemSolutionImpl create(AssignmentCandidateSolution solution, BoundAssignmentProblem problem) {
        HashSet temporalResourceAssignments = Sets.newHashSet();
        AssignmentCandidate candidate = solution.getCandidate();
        List<Integer> timeIndices = candidate.getTimeIndices();
        Map<String, Map<AssignmentResource, MutablePositivePrimitivesMap<SortableId>>> groupedAssignments = solution.getResourceToTypeAssignments();
        HashMap resourceStates = Maps.newHashMap();
        for (StageTaskProblem stageTaskProblem : problem.getStageTaskProblems()) {
            Map<AssignmentResource, MutablePositivePrimitivesMap<SortableId>> resourceToTypeAssignments = groupedAssignments.get(stageTaskProblem.getId());
            for (Map.Entry<AssignmentResource, MutablePositivePrimitivesMap<SortableId>> resourceAssignmentEntry : resourceToTypeAssignments.entrySet()) {
                AssignmentResource resource = resourceAssignmentEntry.getKey();
                if (!resourceStates.containsKey(resource)) {
                    resourceStates.put(resource, VariableAvailabilityState.initFromIndices(timeIndices, resource));
                }
                PositivePrimitivesMap typeAssignments = resourceAssignmentEntry.getValue();
                Set<TemporalResourceAssignment> assignments = AssignmentProblemSolutionImpl.createTemporalResourceAssignments(stageTaskProblem.getId(), resource, timeIndices, typeAssignments, (VariableAvailabilityState)resourceStates.get(resource));
                temporalResourceAssignments.addAll(assignments);
            }
        }
        AssignmentProblemSolutionImpl instance = new AssignmentProblemSolutionImpl(temporalResourceAssignments);
        return instance;
    }

    private static Set<TemporalResourceAssignment> createTemporalResourceAssignments(String id, AssignmentResource resource, List<Integer> timeIndices, PositivePrimitivesMap<SortableId> typeAssignments, VariableAvailabilityState availabilityState) {
        HashSet temporalAssignments = Sets.newHashSet();
        ArrayList openTimeIndices = Lists.newArrayList(timeIndices);
        SortedPositivePrimitiveMap<SortableId> sortedMap = RmCollectionUtils.getSortedMap(typeAssignments);
        block0: for (SortableId typeId : sortedMap.keySet()) {
            float value = sortedMap.get(typeId);
            for (Integer openTimeIndex : openTimeIndices) {
                float availability = availabilityState.getAvailability(openTimeIndex);
                float assignmentValue = Math.min(value, availability);
                if ((double)assignmentValue == 0.0) continue;
                ResourceAssignmentImpl temporalResourceAssignment = new ResourceAssignmentImpl(id, resource, typeId, assignmentValue, openTimeIndex);
                temporalAssignments.add(temporalResourceAssignment);
                value -= assignmentValue;
                availabilityState.reduce(openTimeIndex, assignmentValue);
                if (!((double)value <= 0.0)) continue;
                continue block0;
            }
        }
        return temporalAssignments;
    }
}

