/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.util.function;

import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.rm.jpo.scheduling.util.function.MutableBoundDiscreteBooleanFunction;
import com.atlassian.rm.jpo.scheduling.util.function.MutableBoundedStepFunctionTroveImpl;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import gnu.trove.list.array.TByteArrayList;
import java.util.Collections;
import java.util.List;

public class MutableBoundBooleanFunction
implements MutableBoundDiscreteBooleanFunction {
    private static final Log LOGGER = Log.with(MutableBoundedStepFunctionTroveImpl.class);
    final List<Integer> xs;
    final TByteArrayList ys;

    public MutableBoundBooleanFunction(int start, int end, boolean value) {
        Preconditions.checkArgument((start <= end ? 1 : 0) != 0, (Object)"start point must be smaller end point");
        this.xs = Lists.newArrayList();
        this.ys = new TByteArrayList();
        this.xs.add(start);
        this.ys.add(this.toByte(value));
        if (start != end) {
            this.xs.add(end);
            this.ys.add(this.toByte(value));
        }
    }

    @Override
    public int getLowerSpecificationBound() {
        return this.xs.get(0);
    }

    @Override
    public boolean getAt(int x) {
        int index = Collections.binarySearch(this.xs, x);
        if (index >= 0) {
            return this.toBoolean(this.ys.get(index));
        }
        int insertionPoint = -index - 1;
        if (insertionPoint == 0) {
            throw new IllegalArgumentException();
        }
        if (insertionPoint >= this.ys.size()) {
            throw new IllegalArgumentException();
        }
        return this.toBoolean(this.ys.get(insertionPoint - 1));
    }

    @Override
    public boolean contains(int timeStep) {
        return this.xs.get(0) <= timeStep && timeStep <= this.xs.get(this.xs.size() - 1);
    }

    @Override
    public int getUpperSpecificationBound() {
        return this.xs.get(this.xs.size() - 1);
    }

    @Override
    public void setAt(int x, boolean y) {
        if (this.xs.get(0) > x || x > this.xs.get(this.xs.size() - 1)) {
            LOGGER.warn("invalid function call for: %s", x);
            return;
        }
        this.setAtWithIndex(x, y);
    }

    @Override
    public void setIn(int startInclusive, int endInclusive, boolean y) {
        if (this.xs.get(0) > startInclusive) {
            startInclusive = this.xs.get(0);
        }
        if (endInclusive > this.xs.get(this.xs.size() - 1)) {
            endInclusive = this.xs.get(this.xs.size() - 1);
        }
        if (startInclusive > endInclusive) {
            return;
        }
        int listStartIndex = Math.max(this.setAtWithIndex(startInclusive, y), 0);
        int listEndIndex = Math.min(this.setAtWithIndex(endInclusive, y), this.xs.size() - 1);
        for (int i = listStartIndex + 1; i < listEndIndex; ++i) {
            this.ys.remove(listStartIndex + 1, 1);
            this.xs.remove(listStartIndex + 1);
        }
    }

    private int setAtWithIndex(int x, boolean y) {
        boolean oldValue = this.getAt(x);
        int index = Collections.binarySearch(this.xs, x);
        int listSize = this.ys.size();
        if (index >= 0) {
            int nextX;
            if (index < listSize - 1 && (nextX = this.xs.get(index + 1).intValue()) != x + 1) {
                this.xs.add(index + 1, x + 1);
                this.ys.insert(index + 1, this.toArray(oldValue));
            }
            this.ys.set(index, this.toByte(y));
            return index;
        }
        int insertionPoint = -index - 1;
        if (insertionPoint == 0) {
            return -1;
        }
        if (insertionPoint >= listSize) {
            return listSize;
        }
        int nextX = this.xs.get(insertionPoint);
        if (nextX != x + 1) {
            this.xs.add(insertionPoint, x + 1);
            this.ys.insert(insertionPoint, this.toArray(oldValue));
        }
        this.ys.insert(insertionPoint, this.toArray(y));
        this.xs.add(insertionPoint, x);
        return insertionPoint;
    }

    private byte[] toArray(boolean value) {
        return new byte[]{this.toByte(value)};
    }

    public static MutableBoundBooleanFunction create(int start, int end, boolean value) {
        return new MutableBoundBooleanFunction(start, end, value);
    }

    private byte toByte(boolean value) {
        if (value) {
            return 1;
        }
        return 0;
    }

    private boolean toBoolean(byte b) {
        return b > 0;
    }
}

