/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.util.function;

import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.rm.jpo.scheduling.util.function.IIntegerInterval;
import com.atlassian.rm.jpo.scheduling.util.function.IntegerInterval;
import com.atlassian.rm.jpo.scheduling.util.function.MutableBoundedStepFunction;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import gnu.trove.list.array.TFloatArrayList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class MutableBoundedStepFunctionTroveImpl
implements MutableBoundedStepFunction {
    private static final Log LOGGER = Log.with(MutableBoundedStepFunctionTroveImpl.class);
    final List<Integer> xs;
    final TFloatArrayList ys;

    public MutableBoundedStepFunctionTroveImpl(int start, int end, float value) {
        Preconditions.checkArgument((start <= end ? 1 : 0) != 0, (Object)"start point must be smaller end point");
        this.xs = Lists.newArrayList();
        this.ys = new TFloatArrayList();
        this.xs.add(start);
        this.ys.add(value);
        if (start != end) {
            this.xs.add(end);
            this.ys.add(value);
        }
    }

    @Override
    public int getLowerSpecificationBound() {
        return this.xs.get(0);
    }

    @Override
    public float getAt(int x) {
        int index = Collections.binarySearch(this.xs, x);
        if (index >= 0) {
            return this.ys.get(index);
        }
        int insertionPoint = -index - 1;
        if (insertionPoint == 0) {
            throw new IllegalArgumentException();
        }
        if (insertionPoint >= this.ys.size()) {
            throw new IllegalArgumentException();
        }
        return this.ys.get(insertionPoint - 1);
    }

    @Override
    public boolean contains(int timeStep) {
        return this.xs.get(0) <= timeStep && timeStep <= this.xs.get(this.xs.size() - 1);
    }

    @Override
    public int getUpperSpecificationBound() {
        return this.xs.get(this.xs.size() - 1);
    }

    @Override
    public void setAt(int x, float y) {
        if (this.xs.get(0) > x || x > this.xs.get(this.xs.size() - 1)) {
            LOGGER.warn("invalid function call for: %s", x);
            return;
        }
        this.setAtWithIndex(x, y);
    }

    @Override
    public void setIn(int startInclusive, int endInclusive, float y) {
        if (startInclusive > endInclusive) {
            return;
        }
        if (this.xs.get(0) > startInclusive) {
            startInclusive = this.xs.get(0);
        }
        if (endInclusive > this.xs.get(this.xs.size() - 1)) {
            endInclusive = this.xs.get(this.xs.size() - 1);
        }
        int listStartIndex = Math.max(this.setAtWithIndex(startInclusive, y), 0);
        int listEndIndex = Math.min(this.setAtWithIndex(endInclusive, y), this.xs.size() - 1);
        for (int i = listStartIndex + 1; i < listEndIndex; ++i) {
            this.ys.remove(listStartIndex + 1, 1);
            this.xs.remove(listStartIndex + 1);
        }
    }

    @Override
    public List<IIntegerInterval> getZeroIntervals() {
        ArrayList intervals = Lists.newArrayList();
        boolean inZeroInterval = false;
        int nextStart = Integer.MIN_VALUE;
        for (int i = 0; i < this.xs.size(); ++i) {
            if (!inZeroInterval && this.ys.get(i) == 0.0f && i != this.xs.size() - 1) {
                inZeroInterval = true;
                nextStart = this.xs.get(i);
                continue;
            }
            if (inZeroInterval && this.ys.get(i) != 0.0f) {
                inZeroInterval = false;
                intervals.add(new IntegerInterval(nextStart, this.xs.get(i) - 1));
                continue;
            }
            if (inZeroInterval && i == this.xs.size() - 1) {
                intervals.add(new IntegerInterval(nextStart, this.xs.get(i)));
                continue;
            }
            if (inZeroInterval || i != this.xs.size() - 1 || this.ys.get(i) != 0.0f) continue;
            intervals.add(new IntegerInterval(this.xs.get(i), this.xs.get(i)));
        }
        return intervals;
    }

    private int setAtWithIndex(int x, float y) {
        float oldValue = this.getAt(x);
        int index = Collections.binarySearch(this.xs, x);
        int listSize = this.ys.size();
        if (index >= 0) {
            int nextX;
            if (index < listSize - 1 && (nextX = this.xs.get(index + 1).intValue()) != x + 1) {
                this.xs.add(index + 1, x + 1);
                this.ys.insert(index + 1, this.toArray(oldValue));
            }
            this.ys.set(index, y);
            return index;
        }
        int insertionPoint = -index - 1;
        if (insertionPoint == 0) {
            return -1;
        }
        if (insertionPoint >= listSize) {
            return listSize;
        }
        int nextX = this.xs.get(insertionPoint);
        if (nextX != x + 1) {
            this.xs.add(insertionPoint, x + 1);
            this.ys.insert(insertionPoint, this.toArray(oldValue));
        }
        this.ys.insert(insertionPoint, this.toArray(y));
        this.xs.add(insertionPoint, x);
        return insertionPoint;
    }

    private float[] toArray(float value) {
        return new float[]{value};
    }

    public static MutableBoundedStepFunctionTroveImpl create(int start, int end, float value) {
        return new MutableBoundedStepFunctionTroveImpl(start, end, value);
    }
}

