/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.util.search;

import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.rm.jpo.scheduling.util.LogUtil;
import com.atlassian.rm.jpo.scheduling.util.search.Fringe;
import com.atlassian.rm.jpo.scheduling.util.search.InterruptableFunction;
import com.atlassian.rm.jpo.scheduling.util.search.SearchState;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import javax.annotation.concurrent.Immutable;

@Immutable
public class FirstSolutionTreeSearch<T, S> {
    private static final Log LOGGER = Log.with(FirstSolutionTreeSearch.class);

    public Optional<S> tryFindFirstSolution(Fringe<T> fringe, InterruptableFunction<T, S> stateTransformer) throws InterruptedException {
        Preconditions.checkNotNull(fringe, (Object)"fringe must not be null");
        Preconditions.checkNotNull(stateTransformer, (Object)"state transformer must not be null");
        LogUtil.debug(LOGGER, "start tree search for fringe: %s", fringe);
        while (!fringe.isEmpty()) {
            SearchState<T> state = fringe.getNext();
            S solution = stateTransformer.apply(state.getCandidate());
            if (solution == null) continue;
            LogUtil.debug(LOGGER, "found solution: %s", solution);
            return Optional.of(solution);
        }
        LogUtil.debug(LOGGER, "no solution found");
        return Optional.absent();
    }
}

