/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.entities.plans;

public enum PlanningUnit {
    HOURS("hours"),
    DAYS("days"),
    STORY_POINTS("storypoints");

    private final String unit;

    private PlanningUnit(String unit) {
        this.unit = unit;
    }

    public String unit() {
        return this.unit;
    }

    public String toString() {
        return this.unit;
    }

    public static boolean check(String value) {
        return "hours".equals(value) || "days".equals(value) || "storypoints".equals(value);
    }

    public static PlanningUnit from(String value) {
        if (HOURS.toString().equals(value)) {
            return HOURS;
        }
        if (DAYS.toString().equals(value)) {
            return DAYS;
        }
        if (STORY_POINTS.toString().equals(value)) {
            return STORY_POINTS;
        }
        throw new IllegalArgumentException("Unknown planning unit: " + value);
    }
}

