/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.generator;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.radiantminds.roadmap.common.data.entities.common.IDescribable;
import com.radiantminds.roadmap.common.data.entities.releases.IRelease;
import com.radiantminds.roadmap.common.data.entities.releases.IStream;
import com.radiantminds.roadmap.common.data.entities.skills.ISkill;
import com.radiantminds.roadmap.common.data.entities.skills.IStage;
import com.radiantminds.roadmap.common.data.generator.settings.ISkillConfiguration;
import com.radiantminds.roadmap.common.data.generator.settings.IStageConfiguration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.Set;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeFormatterBuilder;

public class GeneratorUtils {
    public static final DateTimeFormatter FORMATTER = new DateTimeFormatterBuilder().appendDayOfMonth(2).appendLiteral('.').appendMonthOfYear(2).appendLiteral('.').appendYear(4, 4).toFormatter();

    public static <T extends IDescribable> Optional<T> tryFindWithTitle(final String title, Collection<T> describables) {
        try {
            IDescribable element = (IDescribable)Iterables.find(describables, (Predicate)new Predicate<T>(){

                public boolean apply(T input) {
                    String inputTitle = input.getTitle();
                    return title.equals(inputTitle);
                }
            });
            return Optional.of((Object)element);
        }
        catch (NoSuchElementException e) {
            return Optional.absent();
        }
    }

    public static Set<ISkill> getSkills(Collection<IStage> stages) {
        HashSet skills = Sets.newHashSet();
        for (IStage stage : stages) {
            skills.addAll(stage.getSkills());
        }
        return skills;
    }

    public static Set<IRelease> getReleases(Collection<IStream> streams) {
        HashSet releases = Sets.newHashSet();
        for (IStream stream : streams) {
            releases.addAll(stream.getReleases());
        }
        return releases;
    }

    public static int getRandomFromInterval(int min, int max, Random random) {
        return random.nextInt(max - min + 1) + min;
    }

    public static LinkedHashMap<String, Set<String>> getStageTitleToSkillTitlesMap(List<IStageConfiguration> stageConfigurations) {
        LinkedHashMap map = Maps.newLinkedHashMap();
        for (IStageConfiguration stageConfiguration : stageConfigurations) {
            String stageTitle = stageConfiguration.getTitle();
            List<ISkillConfiguration> skillConfigurations = stageConfiguration.getSkillConfigurations();
            Set<String> skillTitles = GeneratorUtils.getTitles(skillConfigurations);
            map.put(stageTitle, skillTitles);
        }
        return map;
    }

    private static Set<String> getTitles(Collection<ISkillConfiguration> skillConfigurations) {
        HashSet titles = Sets.newHashSet();
        for (ISkillConfiguration configuration : skillConfigurations) {
            titles.add(configuration.getTitle());
        }
        return titles;
    }

    public static <T> List<T> selectRandomSubset(List<T> allElements, int cardinality, Random random) {
        if (cardinality >= allElements.size()) {
            return allElements;
        }
        ArrayList list = Lists.newArrayList(allElements);
        Collections.shuffle(list, random);
        return list.subList(0, cardinality);
    }

    public static <T> T selectRandomElement(List<T> teamConfigurations, Random random) {
        ArrayList elementList = Lists.newArrayList(teamConfigurations);
        Collections.shuffle(elementList);
        return (T)elementList.get(0);
    }

    public static Long parseDate(String startDate) {
        return FORMATTER.parseDateTime(startDate).withZone(DateTimeZone.UTC).getMillis();
    }
}

