/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.generator.backlog;

import com.google.common.collect.Lists;
import com.radiantminds.roadmap.common.data.generator.backlog.IBacklogConfiguration;
import com.radiantminds.roadmap.common.data.generator.backlog.IDependencyConfiguration;
import com.radiantminds.roadmap.common.data.generator.backlog.IEpicConfiguration;
import java.util.Collections;
import java.util.List;
import javax.annotation.concurrent.Immutable;

@Immutable
public class BacklogConfiguration
implements IBacklogConfiguration {
    private final List<IEpicConfiguration> epicConfigurations;
    private final IDependencyConfiguration dependencyDefinition;

    public BacklogConfiguration(List<IEpicConfiguration> epicConfigurations, IDependencyConfiguration dependencyDefinition) {
        this.epicConfigurations = Collections.unmodifiableList(epicConfigurations);
        this.dependencyDefinition = dependencyDefinition;
    }

    public BacklogConfiguration(List<IEpicConfiguration> epicConfigurations) {
        this(epicConfigurations, null);
    }

    public BacklogConfiguration() {
        this(Lists.newArrayList(), null);
    }

    @Override
    public List<IEpicConfiguration> getEpicConfigurations() {
        return this.epicConfigurations;
    }

    @Override
    public IDependencyConfiguration getDependencyConfiguration() {
        return this.dependencyDefinition;
    }
}

