/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.generator.teams;

import com.radiantminds.roadmap.common.data.generator.teams.IAvailabilityConfiguration;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class AvailabilityConfiguration
implements IAvailabilityConfiguration {
    private final Long startDate;
    private final Long endDate;
    private final Double availability;

    public AvailabilityConfiguration(Long startDate, Long endDate, Double availability) {
        this.startDate = startDate;
        this.endDate = endDate;
        this.availability = availability;
    }

    public AvailabilityConfiguration(Integer daysFromNowStart, Integer daysFromNowEnd, Double availability) {
        this.startDate = this.getInstant(daysFromNowStart);
        this.endDate = this.getInstant(daysFromNowEnd);
        this.availability = availability;
    }

    private Long getInstant(Integer days) {
        if (days == null) {
            return null;
        }
        DateTime now = new DateTime(DateTimeZone.UTC);
        DateTime plusDays = now.plusDays(days.intValue());
        return plusDays.getMillis();
    }

    @Override
    public Long getStartDate() {
        return this.startDate;
    }

    @Override
    public Long getEndDate() {
        return this.endDate;
    }

    @Override
    public Double getAvailability() {
        return this.availability;
    }
}

