/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.integrity.rank;

import com.atlassian.pocketknife.api.logging.Log;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.radiantminds.roadmap.common.data.activeobjects.ActiveObjectsUtilities;
import com.radiantminds.roadmap.common.data.entities.common.ISortable;
import com.radiantminds.roadmap.common.data.integrity.DatabaseIntegrityConfiguration;
import com.radiantminds.roadmap.common.data.integrity.rank.SortOrderExistenceIntegrityChecker;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.releases.AORelease;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.releases.AOStream;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.AOQueryGenerator;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.BaseAOPersistenceSQL;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.statements.IQuery;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@DatabaseIntegrityConfiguration(requires={SortOrderExistenceIntegrityChecker.class})
public class ReleaseSortOrderExistenceIntegrityChecker
extends SortOrderExistenceIntegrityChecker {
    private static final Log LOGGER = Log.with(ReleaseSortOrderExistenceIntegrityChecker.class);

    @Autowired
    public ReleaseSortOrderExistenceIntegrityChecker(ActiveObjectsUtilities activeObjectsUtilities) {
        super(activeObjectsUtilities);
    }

    @Override
    protected List<Class<? extends ISortable>> getApplicableTables() {
        return Lists.newArrayList((Object[])new Class[]{AORelease.class});
    }

    @Override
    protected void checkClassForRankIntegrity(Connection connection, String planId, Class<? extends ISortable> clazz) throws SQLException {
        Set<String> idsWithoutSortOrders = this.getNonLaterIdsWithoutSortOrders(clazz, planId, connection);
        if (idsWithoutSortOrders.size() > 0) {
            for (String id : idsWithoutSortOrders) {
                LOGGER.warn("Found rank integrity issue: ID %s in table %s has no sort order.", id, clazz);
            }
            this.setSortOrderToZero(clazz, connection, idsWithoutSortOrders);
            LOGGER.info("Set sort order of broken items to zero.", new Object[0]);
        }
    }

    private Set<String> getNonLaterIdsWithoutSortOrders(Class<? extends ISortable> table, final String planId, Connection connection) throws SQLException {
        return this.sql(new IQuery<Set<String>>(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.withTable(AORelease.class, "t").withTable(AOStream.class, "s").select().colId("t").from("t").leftJoin().table("s").on().col("t", "aoStream").eq().colId("s").where().col("t", "sortOrder").isNull().and().col("t", "isLaterRelease").isNull().and().col("s", "aoPlan").eq().numeric(planId);
            }

            @Override
            public Set<String> handleResult(ResultSet result) throws Exception {
                HashSet ids = Sets.newHashSet();
                while (result.next()) {
                    ids.add(BaseAOPersistenceSQL.getString(result, 1));
                }
                return ids;
            }
        }, connection, false);
    }
}

