/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.persistence;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.radiantminds.roadmap.common.data.activeobjects.ActiveObjectsUtilities;
import com.radiantminds.roadmap.common.data.persistence.PersistenceIndex;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.IEntityPersistence;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class SpringPersistenceIndex
implements PersistenceIndex {
    private final ApplicationContext context;

    @Autowired
    public SpringPersistenceIndex(ApplicationContext context) {
        this.context = context;
    }

    @Override
    public List<IEntityPersistence> getPersistenceBeans() {
        return Lists.newArrayList(this.context.getBeansOfType(IEntityPersistence.class).values());
    }

    @Override
    public <T> T getBeanFromContext(Class<T> persistenceClazz) {
        return (T)Iterables.getFirst(this.context.getBeansOfType(persistenceClazz).values(), null);
    }

    @Override
    public ActiveObjectsUtilities getPersistenceUtilityBean() {
        return (ActiveObjectsUtilities)Iterables.getFirst(this.context.getBeansOfType(ActiveObjectsUtilities.class).values(), null);
    }
}

