/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.persistence.ao;

import com.radiantminds.roadmap.common.data.activeobjects.ActiveObjectsUtilities;
import com.radiantminds.roadmap.common.data.entities.common.ISortable;
import com.radiantminds.roadmap.common.data.persistence.PersistenceException;
import com.radiantminds.roadmap.common.data.persistence.ao.AOEntityPersistence;
import com.radiantminds.roadmap.common.data.persistence.ao.common.AOIdentifiable;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.common.SortOrderUtils;
import java.sql.SQLException;

public abstract class AOSortableEntityPersistence<TEntityInterface extends ISortable, TAOInterface extends AOIdentifiable>
extends AOEntityPersistence<TEntityInterface, TAOInterface> {
    private final SortOrderUtils sortOrderUtils;

    public AOSortableEntityPersistence(ActiveObjectsUtilities utils, Class<TEntityInterface> entityClazz, Class<TAOInterface> aoClazz) {
        super(utils, entityClazz, aoClazz);
        this.sortOrderUtils = new SortOrderUtils(utils);
    }

    @Override
    public boolean delete(String id, boolean inCascade) throws PersistenceException {
        try {
            this.sortOrderUtils.clearAndAdaptSortOrder(id, this.getAoClazz());
        }
        catch (SQLException ex) {
            throw new PersistenceException("Failed to clear sort order while deleting entity '" + id + "' on " + this.getAoClazz().getSimpleName());
        }
        return super.delete(id, inCascade);
    }

    @Override
    protected void onBeforeCreate(TEntityInterface entity) throws PersistenceException {
        entity.setSortOrder(-1L);
    }

    @Override
    public void onAfterCreate(TEntityInterface entity) throws PersistenceException {
        this.sortOrderUtils.shiftAll(entity.getOrderRangeIdentifier(), this.getAoClazz());
    }
}

