/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.persistence.ao.common;

import com.radiantminds.roadmap.common.data.activeobjects.ActiveObjectsAccessor;
import com.radiantminds.roadmap.common.data.persistence.ao.common.AOIdentifiable;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.doorstop.AODoorStop;
import java.sql.SQLException;
import java.util.concurrent.Callable;
import net.java.ao.DBParam;
import net.java.ao.EntityManager;
import net.java.ao.RawEntity;
import net.java.ao.Transaction;

public class EntityManagerActiveObjectsAccessor
implements ActiveObjectsAccessor {
    private static EntityManager ENTITY_MANAGER;
    private final EntityManager entityManager;

    public EntityManagerActiveObjectsAccessor(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    @Override
    public <AOEntityType extends AOIdentifiable> AOEntityType get(Class<AOEntityType> aoClazz, int i) {
        try {
            return (AOEntityType)((AOIdentifiable)this.entityManager.get(aoClazz, (Object)i));
        }
        catch (SQLException e) {
            throw new RuntimeException("GET failed", e);
        }
    }

    @Override
    public <AOEntityType extends AOIdentifiable> AOEntityType create(Class<AOEntityType> aoClazz) {
        try {
            return (AOEntityType)((AOIdentifiable)this.entityManager.create(aoClazz, new DBParam[0]));
        }
        catch (Exception e) {
            throw new RuntimeException("CREATE failed", e);
        }
    }

    @Override
    public <AOEntityType extends AOIdentifiable> AOEntityType create(Class<AOEntityType> aoClazz, int identifier) {
        try {
            return (AOEntityType)((AOIdentifiable)this.entityManager.create(aoClazz, new DBParam[]{new DBParam("ID_OTHER", (Object)identifier)}));
        }
        catch (SQLException e) {
            throw new RuntimeException("CREATE with id failed", e);
        }
    }

    @Override
    public <AOEntityType extends AOIdentifiable> AOEntityType[] find(Class<AOEntityType> aoClazz) {
        try {
            return (AOIdentifiable[])this.entityManager.find(aoClazz);
        }
        catch (SQLException e) {
            throw new RuntimeException("FIND failed", e);
        }
    }

    @Override
    public <AOEntityType extends AOIdentifiable> AOEntityType[] find(Class<AOEntityType> aoClazz, String whereClause, Object ... parameters) {
        try {
            return (AOIdentifiable[])this.entityManager.find(aoClazz, whereClause, parameters);
        }
        catch (SQLException ex) {
            throw new RuntimeException("FIND with WHERE failed", ex);
        }
    }

    @Override
    public <AOEntityType extends AOIdentifiable> boolean delete(Class<AOEntityType> aoClazz, AOEntityType entity) {
        try {
            if (entity != null) {
                this.entityManager.delete(new RawEntity[]{entity});
                return true;
            }
            return false;
        }
        catch (SQLException e) {
            throw new RuntimeException("DELETE failed", e);
        }
    }

    @Override
    public <T> T executeInTransaction(final Callable<T> callable) throws Exception {
        return (T)new Transaction<T>(this.entityManager){

            protected T run() throws SQLException {
                try {
                    return callable.call();
                }
                catch (Exception e) {
                    throw new SQLException("Failed to execute in Transaction.", e);
                }
            }
        }.execute();
    }

    @Override
    public void flush() {
        this.entityManager.flushAll();
    }

    @Override
    public EntityManager getEntityManager() {
        try {
            if (ENTITY_MANAGER == null) {
                AODoorStop doorStop = (AODoorStop)this.entityManager.get(AODoorStop.class, (Object)1);
                if (doorStop == null) {
                    doorStop = (AODoorStop)this.entityManager.create(AODoorStop.class, new DBParam[0]);
                    doorStop.save();
                }
                ENTITY_MANAGER = doorStop.getEntityManager();
            }
            return ENTITY_MANAGER;
        }
        catch (Exception ex) {
            throw new RuntimeException("EntityManager not accessible via reflection!", ex);
        }
    }
}

