/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.persistence.ao.entities.common.sql;

import com.google.common.collect.Lists;
import com.radiantminds.roadmap.common.data.activeobjects.ActiveObjectsUtilities;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.plans.AOPlan;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.AOQueryGenerator;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.BaseAOPersistenceSQL;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.statements.IQuery;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.EntityInfo;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class EntityInfoSQL
extends BaseAOPersistenceSQL {
    public EntityInfoSQL(ActiveObjectsUtilities activeObjectsUtilities) {
        super(activeObjectsUtilities);
    }

    public EntityInfo getEntityInfo(final String id, final Class<?> entityClass, final ParentRelationship ... parentRelationships) throws SQLException {
        return this.sql(new IQuery<EntityInfo>(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.withTable(entityClass, "e").withTable(AOPlan.class, "p");
                for (int i = 0; i < parentRelationships.length; ++i) {
                    generator.withTable(parentRelationships[i].getClazz(), "x" + i);
                }
                generator.select().col("e", "version").colId("p").col("p", "planVersion").col("p", "schedulingVersion").from("e");
                String lastTable = "e";
                for (int i = 0; i < parentRelationships.length; ++i) {
                    generator.leftJoin().table("x" + i).on().colId("x" + i).eq().col(lastTable, parentRelationships[i].getParentColumn());
                    lastTable = "x" + i;
                }
                generator.leftJoin().table("p").on().colId("p").eq().col(lastTable, "aoplan");
                generator.where().colId("e").eq().numeric(id);
            }

            @Override
            public EntityInfo handleResult(ResultSet result) throws Exception {
                if (result.next()) {
                    return new EntityInfo.Impl(id, EntityInfoSQL.getLong(result, 1), BaseAOPersistenceSQL.getString(result, 2), EntityInfoSQL.getLong(result, 3), EntityInfoSQL.getLong(result, 4));
                }
                return null;
            }
        });
    }

    public List<EntityInfo> getEntityInfo(final Collection<String> ids, final Class<?> entityClass, final ParentRelationship ... parentRelationships) throws SQLException {
        return this.sql(new IQuery<List<EntityInfo>>(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.withTable(entityClass, "e").withTable(AOPlan.class, "p");
                for (int i = 0; i < parentRelationships.length; ++i) {
                    generator.withTable(parentRelationships[i].getClazz(), "x" + i);
                }
                generator.select().colId("e").col("e", "version").colId("p").col("p", "planVersion").col("p", "schedulingVersion").from("e");
                String lastTable = "e";
                for (int i = 0; i < parentRelationships.length; ++i) {
                    generator.leftJoin().table("x" + i).on().colId("x" + i).eq().col(lastTable, parentRelationships[i].getParentColumn());
                    lastTable = "x" + i;
                }
                generator.leftJoin().table("p").on().colId("p").eq().col(lastTable, "aoplan");
                generator.where().inNumeric(new AOQueryGenerator.InOperandCallback(){

                    @Override
                    public void generateOperand(AOQueryGenerator generator) {
                        generator.colId("e");
                    }
                }, ids);
            }

            @Override
            public List<EntityInfo> handleResult(ResultSet set) throws Exception {
                ArrayList retVal = Lists.newArrayList();
                while (set.next()) {
                    retVal.add(new EntityInfo.Impl(BaseAOPersistenceSQL.getString(set, 1), EntityInfoSQL.getLong(set, 2), BaseAOPersistenceSQL.getString(set, 3), EntityInfoSQL.getLong(set, 4), EntityInfoSQL.getLong(set, 5)));
                }
                return retVal;
            }
        });
    }

    public static class ParentRelationship {
        private final Class<?> clazz;
        private final String parentColumn;

        public ParentRelationship(Class<?> clazz, String parentColumn) {
            this.clazz = clazz;
            this.parentColumn = parentColumn;
        }

        public Class<?> getClazz() {
            return this.clazz;
        }

        public String getParentColumn() {
            return this.parentColumn;
        }
    }
}

