/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.persistence.ao.entities.configuration;

import com.google.common.base.Optional;
import com.radiantminds.roadmap.common.data.activeobjects.ActiveObjectsUtilities;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.configuration.AOConfiguration;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.AOQueryGenerator;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.BaseAOPersistenceSQL;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.statements.IQuery;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.statements.IUpdate;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioConfigurationPersistence;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PortfolioActiveObjectsConfigurationPersistence
extends BaseAOPersistenceSQL
implements PortfolioConfigurationPersistence {
    @Autowired
    public PortfolioActiveObjectsConfigurationPersistence(ActiveObjectsUtilities activeObjectsUtilities) {
        super(activeObjectsUtilities);
    }

    @Override
    public boolean isInitialized() throws SQLException {
        return this.sql(new IQuery<Boolean>(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.withTable(AOConfiguration.class, "c").select().col("c", "initialized").from("c");
            }

            @Override
            public Boolean handleResult(ResultSet result) throws Exception {
                Boolean val;
                if (result.next() && (val = BaseAOPersistenceSQL.getBoolean(result, 1)) != null) {
                    return val;
                }
                return false;
            }
        });
    }

    @Override
    public void initialize() throws SQLException {
        this.sql(new IUpdate(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.withTable(AOConfiguration.class, "c").insert().tableNoAlias("c").raw("(").colNoAlias("c", "initialized").raw(") VALUES (").bool(true).raw(")");
            }
        });
    }

    @Override
    public Optional<Integer> getInitState() throws SQLException {
        return this.sql(new IQuery<Optional<Integer>>(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.withTable(AOConfiguration.class, "c").select().col("c", "initState").from("c");
            }

            @Override
            public Optional<Integer> handleResult(ResultSet result) throws Exception {
                if (result.next()) {
                    Integer val = PortfolioActiveObjectsConfigurationPersistence.getInteger(result, 1);
                    return Optional.fromNullable((Object)val);
                }
                return Optional.absent();
            }
        });
    }

    @Override
    public void setInitState(final int state) throws SQLException {
        this.sql(new IUpdate(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.withTable(AOConfiguration.class, "c").update().tableNoAlias("c").set().colNoAlias("c", "initState").eq().numeric(state);
            }
        });
    }
}

