/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.persistence.ao.entities.people;

import com.radiantminds.roadmap.common.data.activeobjects.ActiveObjectsUtilities;
import com.radiantminds.roadmap.common.data.entities.people.IPerson;
import com.radiantminds.roadmap.common.data.entities.people.IResource;
import com.radiantminds.roadmap.common.data.entities.people.ITeam;
import com.radiantminds.roadmap.common.data.persistence.PersistenceException;
import com.radiantminds.roadmap.common.data.persistence.ao.AOSortableEntityPersistence;
import com.radiantminds.roadmap.common.data.persistence.ao.common.TransformerUtils;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.common.sql.EntityInfoSQL;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.ntom.sql.WorkItemToResourceSQL;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.people.AOPerson;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.people.AOResource;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.people.AOTeam;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.people.sql.PersonSQL;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.people.sql.ResourceSQL;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.AOQueryGenerator;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.EntityInfo;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.IEntityPersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioPersonPersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioResourcePersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioTeamPersistence;
import com.radiantminds.roadmap.common.extensions.usermanagement.UserManagementExtension;
import java.sql.SQLException;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PortfolioActiveObjectsResourcePersistence
extends AOSortableEntityPersistence<IResource, AOResource>
implements PortfolioResourcePersistence {
    private final WorkItemToResourceSQL workItemToResourceSQL;
    private final PersonSQL personSQL;
    private final ResourceSQL resourceSQL;
    private final EntityInfoSQL entityInfoSQL;
    private final PortfolioPersonPersistence personPersistence;
    private final PortfolioTeamPersistence teamPersistence;

    @Autowired
    public PortfolioActiveObjectsResourcePersistence(ActiveObjectsUtilities utils, PortfolioPersonPersistence personPersistence, PortfolioTeamPersistence teamPersistence, UserManagementExtension userManagementExtension) {
        super(utils, IResource.class, AOResource.class);
        this.personPersistence = personPersistence;
        this.teamPersistence = teamPersistence;
        this.workItemToResourceSQL = new WorkItemToResourceSQL(utils, this);
        this.personSQL = new PersonSQL(utils, userManagementExtension);
        this.resourceSQL = new ResourceSQL(utils);
        this.entityInfoSQL = new EntityInfoSQL(utils);
    }

    @Override
    public Class<? extends IEntityPersistence> getPersistenceType() {
        return PortfolioResourcePersistence.class;
    }

    @Override
    protected void transform(IResource source, AOResource target) throws Exception {
        TransformerUtils.transformVersionable(source, target);
        TransformerUtils.transformSortable(source, target);
        target.setAvailability(source.getAvailability());
        if (source.getPerson() != null) {
            target.setPerson((IPerson)this.personPersistence.get(source.getPerson().getId()));
        }
        if (source.getTeam() != null) {
            target.setTeam((ITeam)this.teamPersistence.get(source.getTeam().getId()));
        }
    }

    @Override
    public boolean delete(String id, boolean inCascade) throws PersistenceException {
        try {
            this.workItemToResourceSQL.clearResourceAssignmentsForResources(id);
        }
        catch (SQLException ex) {
            throw new PersistenceException("Failed to cascade delete resource assignments for resource '" + id + "'", ex);
        }
        boolean retVal = super.delete(id, inCascade);
        try {
            this.personSQL.deletePersonZombies();
        }
        catch (SQLException ex) {
            throw new PersistenceException("Failed to cascade delete person for resource '" + id + "'", ex);
        }
        return retVal;
    }

    @Override
    public EntityInfo getEntityInfo(String id) throws SQLException {
        return this.entityInfoSQL.getEntityInfo(id, AOResource.class, new EntityInfoSQL.ParentRelationship(AOTeam.class, "aoteam"));
    }

    @Override
    public List<IResource> listForTeam(String teamId) throws SQLException {
        return this.resourceSQL.listForTeam(teamId);
    }

    @Override
    public List<String> getResourceIdsForPersonIds(String planId, List<String> personIds) throws SQLException {
        if (personIds == null) {
            return null;
        }
        return this.resourceSQL.getResourceIdsForPersonIds(planId, personIds);
    }

    @Override
    public void selectAllForPlan(AOQueryGenerator generator, String planId, boolean inOrder) throws SQLException {
        generator.withTable(AOResource.class, "r").withTable(AOPerson.class, "h1").withTable(AOTeam.class, "t").select().raw("r.*").from("r").leftJoin().table("h1").on().col("r", "aoPerson").eq().colId("h1").where().col("h1", "aoplan").eq().numeric(planId);
        if (inOrder) {
            generator.orderBy().raw("(").select().col("t", "sortOrder").from("t").where().colId("t").eq().col("r", "aoTeam").raw("),").col("r", "sortOrder");
        }
    }
}

