/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.persistence.ao.entities.people.sql;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.radiantminds.roadmap.common.data.activeobjects.ActiveObjectsUtilities;
import com.radiantminds.roadmap.common.data.entities.people.IAbility;
import com.radiantminds.roadmap.common.data.entities.people.IPerson;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.people.AOAbility;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.people.AOPerson;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.people.AOResource;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.people.intervals.AOAbsence;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.people.intervals.AOPresence;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.people.sql.PersonIntervalSQL;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.AOQueryGenerator;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.BaseAOPersistenceSQL;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.statements.IQuery;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.statements.IUpdate;
import com.radiantminds.roadmap.common.extensions.usermanagement.UserManagementExtension;
import com.radiantminds.roadmap.common.rest.entities.people.RestAbility;
import com.radiantminds.roadmap.common.rest.entities.people.RestAbsence;
import com.radiantminds.roadmap.common.rest.entities.people.RestPerson;
import com.radiantminds.roadmap.common.rest.entities.people.RestPresence;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PersonSQL
extends BaseAOPersistenceSQL {
    private final PersonIntervalSQL personIntervalSQL;
    private final UserManagementExtension userManagementExtension;

    public PersonSQL(ActiveObjectsUtilities activeObjectsUtilities, UserManagementExtension userManagementExtension) {
        super(activeObjectsUtilities);
        this.userManagementExtension = userManagementExtension;
        this.personIntervalSQL = new PersonIntervalSQL(activeObjectsUtilities);
    }

    public List<IPerson> getAllPersonsWithoutAbilities(final String planId, final boolean enrich) throws SQLException {
        return this.sql(new IQuery<List<IPerson>>(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.withTable(AOPerson.class, "p").select().col("p", "ID_OTHER", false).col("p", "title").col("p", "details").col("p", "version").col("p", "aoexternal").from("p").where().col("p", "aoplan").eq().numeric(planId);
            }

            @Override
            public List<IPerson> handleResult(ResultSet set) throws Exception {
                ArrayList retVal = Lists.newArrayList();
                while (set.next()) {
                    RestPerson person = new RestPerson(BaseAOPersistenceSQL.getString(set, 1), BaseAOPersistenceSQL.getString(set, 2), BaseAOPersistenceSQL.getString(set, 3), BaseAOPersistenceSQL.getString(set, 5));
                    person.setVersion(PersonSQL.getLong(set, 4));
                    if (enrich && person.getExternalId().isPresent()) {
                        PersonSQL.this.enrichPerson(person);
                    }
                    retVal.add(person);
                }
                return retVal;
            }
        });
    }

    public Map<String, IPerson> getPersons(final String planId, final boolean enrich) throws SQLException {
        return this.sql(new IQuery<Map<String, IPerson>>(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.withTable(AOPerson.class, "p").withTable(AOAbility.class, "a").select().colId("p").col("p", "title").col("p", "details").col("p", "version").col("p", "aoexternal").colId("a").col("a", "targetId").col("a", "targetType").col("a", "abilityValue").col("a", "version").from("p").leftJoin().table("a").on().col("a", "aoperson").eq().colId("p").where().col("p", "aoplan").eq().numeric(planId).orderBy().colId("p");
            }

            @Override
            public Map<String, IPerson> handleResult(ResultSet set) throws Exception {
                return PersonSQL.this.handleResult(set, enrich);
            }
        });
    }

    private void enrichPerson(IPerson person) {
        String externalId = (String)person.getExternalId().get();
        if (this.userManagementExtension.isUserManagementFor(externalId) && this.userManagementExtension.exists(externalId)) {
            this.userManagementExtension.enrich(person);
        }
    }

    private Map<String, IPerson> handleResult(ResultSet set, boolean enrich) throws SQLException {
        HashMap retVal = Maps.newHashMap();
        while (set.next()) {
            Integer targetId;
            String personId = PersonSQL.getString(set, 1);
            if (!retVal.containsKey(personId)) {
                RestPerson newPerson = new RestPerson(personId, PersonSQL.getString(set, 2), PersonSQL.getString(set, 3), PersonSQL.getString(set, 5));
                newPerson.setVersion(PersonSQL.getLong(set, 4));
                if (enrich && newPerson.getExternalId().isPresent()) {
                    this.enrichPerson(newPerson);
                }
                retVal.put(personId, newPerson);
            }
            if ((targetId = PersonSQL.getInt(set, 7)) == null) continue;
            RestPerson person = (RestPerson)retVal.get(personId);
            RestAbility newAbility = new RestAbility(PersonSQL.getString(set, 6));
            newAbility.setTargetId(targetId);
            newAbility.setTargetType(PersonSQL.getString(set, 8));
            newAbility.setAbilityValue(PersonSQL.getDouble(set, 9));
            newAbility.setVersion(PersonSQL.getLong(set, 10));
            List<IAbility> abilties = person.getAbilities();
            abilties.add(newAbility);
            person.setAbilities(abilties);
        }
        for (IPerson person : retVal.values()) {
            RestPerson restPerson = (RestPerson)person;
            restPerson.setPresenceIntervals(this.personIntervalSQL.listForPerson(AOPresence.class, RestPresence.class, person.getId()));
            restPerson.setAbsenceIntervals(this.personIntervalSQL.listForPerson(AOAbsence.class, RestAbsence.class, person.getId()));
        }
        return retVal;
    }

    public void deletePersonZombies() throws SQLException {
        final List<String> zombies = this.sql(new IQuery<List<String>>(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.withTable(AOPerson.class, "p").withTable(AOResource.class, "r").select().colId("p").from("p").where().raw("(").select().raw("COUNT(*)").from("r").where().col("r", "aoPerson").eq().colId("p").raw(")").eq().numeric(0);
            }

            @Override
            public List<String> handleResult(ResultSet result) throws Exception {
                ArrayList retVal = Lists.newArrayList();
                while (result.next()) {
                    retVal.add(BaseAOPersistenceSQL.getString(result, 1));
                }
                return retVal;
            }
        });
        if (zombies.size() > 0) {
            this.sql(new IUpdate(){

                @Override
                public void sql(AOQueryGenerator generator) throws Exception {
                    generator.withTable(AOPresence.class, "p").deleteFrom().tableNoAlias("p").where().inNumeric(new AOQueryGenerator.InOperandCallback(){

                        @Override
                        public void generateOperand(AOQueryGenerator generator) {
                            generator.colNoAlias("p", "aoPerson");
                        }
                    }, zombies);
                }
            });
            this.sql(new IUpdate(){

                @Override
                public void sql(AOQueryGenerator generator) throws Exception {
                    generator.withTable(AOAbsence.class, "p").deleteFrom().tableNoAlias("p").where().inNumeric(new AOQueryGenerator.InOperandCallback(){

                        @Override
                        public void generateOperand(AOQueryGenerator generator) {
                            generator.colNoAlias("p", "aoPerson");
                        }
                    }, zombies);
                }
            });
            this.sql(new IUpdate(){

                @Override
                public void sql(AOQueryGenerator generator) throws Exception {
                    generator.withTable(AOAbility.class, "a").deleteFrom().tableNoAlias("a").where().inNumeric(new AOQueryGenerator.InOperandCallback(){

                        @Override
                        public void generateOperand(AOQueryGenerator generator) {
                            generator.colNoAlias("a", "aoPerson");
                        }
                    }, zombies);
                }
            });
            this.sql(new IUpdate(){

                @Override
                public void sql(AOQueryGenerator generator) throws Exception {
                    generator.withTable(AOPerson.class, "p").deleteFrom().tableNoAlias("p").where().inNumeric(new AOQueryGenerator.InOperandCallback(){

                        @Override
                        public void generateOperand(AOQueryGenerator generator) {
                            generator.colIdNoAlias("p");
                        }
                    }, zombies);
                }
            });
        }
    }
}

