/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.persistence.ao.entities.plans.sql;

import com.radiantminds.roadmap.common.data.activeobjects.ActiveObjectsUtilities;
import com.radiantminds.roadmap.common.data.entities.plans.IPlanConfiguration;
import com.radiantminds.roadmap.common.data.generator.template.PlanTemplate;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.plans.AOPlanConfiguration;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.plans.sql.InvalidPlanConfigurationException;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.AOQueryGenerator;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.BaseAOPersistenceSQL;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.statements.IQuery;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.statements.IUpdate;
import com.radiantminds.roadmap.common.rest.entities.plans.RestPlanConfiguration;
import java.sql.ResultSet;
import java.sql.SQLException;

public class PlanConfigurationSQL
extends BaseAOPersistenceSQL {
    private static final String ENABLE_SPRINT_EXCEEDED_WARNINS = "sprintExceededWarn";
    private static final String MINIMUM_LOAD_FOR_UNSTRUCTURED_EPICS = "minLoadUnstrEpics";
    private static final String MAX_ASSIGNABLE_RESOURCES_PER_STORY = "maxResourcesPerStory";
    private static final String STRICT_STORY_STAGE_DIVISION = "strictStageDivision";
    private static final String PLANNING_UNIT = "planningUnit";
    private static final String HEURISTIC_THRESHOLD = "heuristicThreshold";
    private static final String GLOBAL_SPRINT_LENGTH = "globalSprintLength";
    private static final String GLOBAL_DEFAULT_VELOCITY = "globalDefaultVelocity";
    private static final String SPRINT_CONSTRAINT = "hasSprintConstraint";
    private static final String SYNC_START_DEPENDEE = "syncStartEnabled";
    private static final String LINKING_MODE = "linkingMode";
    private static final String TEMPLATE = "templateType";
    private static final String BACKLOG_RECORD_LIMIT = "backlogRecordLimit";
    private static final String IMPORT_LIMIT = "importLimit";
    private static final String PROGRESS_TRACKER_TYPE = "aoProgressTrackerType";
    private static final String PROGRESS_COMPLETE_IF_RESOLVED = "progCmpltIfRslvd";
    private static final String PROGRESS_DISPLAY_UNESTIMATED = "progDsplUnestRtio";
    private static final String PROGRESS_MANUAL_FIELD_NAME = "progFieldName";
    private static final String PROGRESS_STORY_SUBTASK_MODE = "progStrySubTaskMode";
    private static final String DEFAULT_STORY_ESTIMATE = "defaultStoryEstimate";
    private static final String DEFAULT_EPIC_ESTIMATE = "defaultEpicEstimate";
    private static final String HOURS_PER_DAY = "hoursPerDay";
    private static final String DAYS_IN_WEEK = "aOWeekdayConfig";
    private static final String SUGGEST_REPLANNING_ESTIMATES = "suggestReplEstimates";
    public static final String SYNC_STORIES = "syncStories";
    public static final String SYNC_EPICS = "syncEpics";
    public static final String SYNC_INITIATIVES = "syncInitiatives";
    public static final String SYNC_SUMMARY = "syncSummary";
    public static final String SYNC_DESCRIPTION = "syncDescription";
    public static final String SYNC_ESTIMATES = "syncEstimates";
    private static final double ABSENT_DOUBLE_INDICATOR_VALUE = -1.0;

    public PlanConfigurationSQL(ActiveObjectsUtilities activeObjectsUtilities) {
        super(activeObjectsUtilities);
    }

    public IPlanConfiguration getPlanConfiguration(final String planId) throws SQLException {
        return this.sql(new IQuery<IPlanConfiguration>(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.withTable(AOPlanConfiguration.class, "c").select().col("c", PlanConfigurationSQL.ENABLE_SPRINT_EXCEEDED_WARNINS).col("c", PlanConfigurationSQL.SPRINT_CONSTRAINT).col("c", PlanConfigurationSQL.SYNC_START_DEPENDEE).col("c", PlanConfigurationSQL.STRICT_STORY_STAGE_DIVISION).col("c", PlanConfigurationSQL.MINIMUM_LOAD_FOR_UNSTRUCTURED_EPICS).col("c", PlanConfigurationSQL.MAX_ASSIGNABLE_RESOURCES_PER_STORY).col("c", PlanConfigurationSQL.PLANNING_UNIT).col("c", PlanConfigurationSQL.HEURISTIC_THRESHOLD).col("c", PlanConfigurationSQL.GLOBAL_SPRINT_LENGTH).col("c", PlanConfigurationSQL.GLOBAL_DEFAULT_VELOCITY).col("c", PlanConfigurationSQL.LINKING_MODE).col("c", PlanConfigurationSQL.TEMPLATE).col("c", PlanConfigurationSQL.BACKLOG_RECORD_LIMIT).col("c", PlanConfigurationSQL.IMPORT_LIMIT).col("c", PlanConfigurationSQL.PROGRESS_TRACKER_TYPE).col("c", PlanConfigurationSQL.PROGRESS_COMPLETE_IF_RESOLVED).col("c", PlanConfigurationSQL.PROGRESS_DISPLAY_UNESTIMATED).col("c", PlanConfigurationSQL.PROGRESS_MANUAL_FIELD_NAME).col("c", PlanConfigurationSQL.PROGRESS_STORY_SUBTASK_MODE).col("c", PlanConfigurationSQL.DEFAULT_STORY_ESTIMATE).col("c", PlanConfigurationSQL.DEFAULT_EPIC_ESTIMATE).col("c", PlanConfigurationSQL.HOURS_PER_DAY).col("c", PlanConfigurationSQL.DAYS_IN_WEEK).col("c", PlanConfigurationSQL.SUGGEST_REPLANNING_ESTIMATES).col("c", PlanConfigurationSQL.SYNC_STORIES).col("c", PlanConfigurationSQL.SYNC_EPICS).col("c", PlanConfigurationSQL.SYNC_INITIATIVES).col("c", PlanConfigurationSQL.SYNC_SUMMARY).col("c", PlanConfigurationSQL.SYNC_DESCRIPTION).col("c", PlanConfigurationSQL.SYNC_ESTIMATES).from("c").where().col("c", "aoplan").eq().numeric(planId);
            }

            @Override
            public IPlanConfiguration handleResult(ResultSet result) throws Exception {
                if (result.next()) {
                    int i = 1;
                    return new RestPlanConfiguration(BaseAOPersistenceSQL.getBoolean(result, i++), BaseAOPersistenceSQL.getBoolean(result, i++), BaseAOPersistenceSQL.getBoolean(result, i++), BaseAOPersistenceSQL.getBoolean(result, i++), PlanConfigurationSQL.getLong(result, i++), PlanConfigurationSQL.getLong(result, i++), BaseAOPersistenceSQL.getString(result, i++), BaseAOPersistenceSQL.getInt(result, i++), BaseAOPersistenceSQL.getInt(result, i++), BaseAOPersistenceSQL.getDouble(result, i++), BaseAOPersistenceSQL.getString(result, i++), PlanTemplate.parse(BaseAOPersistenceSQL.getString(result, i++)), BaseAOPersistenceSQL.getInt(result, i++), BaseAOPersistenceSQL.getInt(result, i++), BaseAOPersistenceSQL.getString(result, i++), BaseAOPersistenceSQL.getBoolean(result, i++), BaseAOPersistenceSQL.getBoolean(result, i++), BaseAOPersistenceSQL.getString(result, i++), BaseAOPersistenceSQL.getString(result, i++), BaseAOPersistenceSQL.getDouble(result, i++), BaseAOPersistenceSQL.getDouble(result, i++), BaseAOPersistenceSQL.getDouble(result, i++), BaseAOPersistenceSQL.getInt(result, i++), BaseAOPersistenceSQL.getBoolean(result, i++), BaseAOPersistenceSQL.getBoolean(result, i++), BaseAOPersistenceSQL.getBoolean(result, i++), BaseAOPersistenceSQL.getBoolean(result, i++), BaseAOPersistenceSQL.getBoolean(result, i++), BaseAOPersistenceSQL.getBoolean(result, i++), BaseAOPersistenceSQL.getBoolean(result, i++));
                }
                return RestPlanConfiguration.getDefaultConfiguration();
            }
        });
    }

    public void setPlanConfiguration(final String planId, final IPlanConfiguration configuration) throws SQLException, InvalidPlanConfigurationException {
        this.sql(new IUpdate(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                boolean hasPrev = false;
                generator.withTable(AOPlanConfiguration.class, "c").update().tableNoAlias("c").set();
                hasPrev = PlanConfigurationSQL.addFieldSetter(hasPrev, PlanConfigurationSQL.ENABLE_SPRINT_EXCEEDED_WARNINS, configuration.getSprintExceededWarn(), generator);
                hasPrev = PlanConfigurationSQL.addFieldSetter(hasPrev, PlanConfigurationSQL.SPRINT_CONSTRAINT, configuration.getHasSprintConstraint(), generator);
                hasPrev = PlanConfigurationSQL.addFieldSetter(hasPrev, PlanConfigurationSQL.SYNC_START_DEPENDEE, configuration.getSyncStartEnabled(), generator);
                hasPrev = PlanConfigurationSQL.addFieldSetter(hasPrev, PlanConfigurationSQL.STRICT_STORY_STAGE_DIVISION, configuration.getStrictStageDivision(), generator);
                hasPrev = PlanConfigurationSQL.addFieldSetter(hasPrev, PlanConfigurationSQL.MINIMUM_LOAD_FOR_UNSTRUCTURED_EPICS, configuration.getMinLoadUnstrEpics(), generator);
                hasPrev = PlanConfigurationSQL.addFieldSetter(hasPrev, PlanConfigurationSQL.MAX_ASSIGNABLE_RESOURCES_PER_STORY, configuration.getMaxResourcesPerStory(), generator);
                hasPrev = PlanConfigurationSQL.addFieldSetter(hasPrev, PlanConfigurationSQL.PLANNING_UNIT, configuration.getPlanningUnit(), generator);
                hasPrev = PlanConfigurationSQL.addFieldSetter(hasPrev, PlanConfigurationSQL.HEURISTIC_THRESHOLD, configuration.getHeuristicThreshold(), generator);
                hasPrev = PlanConfigurationSQL.addFieldSetter(hasPrev, PlanConfigurationSQL.GLOBAL_SPRINT_LENGTH, configuration.getGlobalSprintLength(), generator);
                hasPrev = PlanConfigurationSQL.addFieldSetter(hasPrev, PlanConfigurationSQL.GLOBAL_DEFAULT_VELOCITY, configuration.getGlobalDefaultVelocity(), generator);
                hasPrev = PlanConfigurationSQL.addFieldSetter(hasPrev, PlanConfigurationSQL.LINKING_MODE, configuration.getLinkingMode(), generator);
                hasPrev = PlanConfigurationSQL.addFieldSetter(hasPrev, PlanConfigurationSQL.TEMPLATE, configuration.getTemplateType(), generator);
                hasPrev = PlanConfigurationSQL.addFieldSetter(hasPrev, PlanConfigurationSQL.BACKLOG_RECORD_LIMIT, configuration.getBacklogRecordLimit(), generator);
                hasPrev = PlanConfigurationSQL.addFieldSetter(hasPrev, PlanConfigurationSQL.IMPORT_LIMIT, configuration.getImportLimit(), generator);
                hasPrev = PlanConfigurationSQL.addFieldSetter(hasPrev, PlanConfigurationSQL.PROGRESS_TRACKER_TYPE, (Object)configuration.getProgressTrackerType(), generator);
                hasPrev = PlanConfigurationSQL.addFieldSetter(hasPrev, PlanConfigurationSQL.PROGRESS_COMPLETE_IF_RESOLVED, configuration.getProgCmpltIfRslvd(), generator);
                hasPrev = PlanConfigurationSQL.addFieldSetter(hasPrev, PlanConfigurationSQL.PROGRESS_DISPLAY_UNESTIMATED, configuration.getProgDsplUnestRtio(), generator);
                hasPrev = PlanConfigurationSQL.addFieldSetter(hasPrev, PlanConfigurationSQL.PROGRESS_MANUAL_FIELD_NAME, configuration.getProgFieldName(), generator);
                hasPrev = PlanConfigurationSQL.addFieldSetter(hasPrev, PlanConfigurationSQL.PROGRESS_STORY_SUBTASK_MODE, configuration.getProgStrySubTaskMode(), generator);
                hasPrev = PlanConfigurationSQL.addFieldSetterForPotentiallyAbsentDouble(hasPrev, PlanConfigurationSQL.DEFAULT_STORY_ESTIMATE, configuration.getDefaultStoryEstimate(), generator);
                hasPrev = PlanConfigurationSQL.addFieldSetterForPotentiallyAbsentDouble(hasPrev, PlanConfigurationSQL.DEFAULT_EPIC_ESTIMATE, configuration.getDefaultEpicEstimate(), generator);
                if (configuration.getHoursPerDay() != null && (configuration.getHoursPerDay() < 1.0 || configuration.getHoursPerDay() > 1.0E7)) {
                    throw new InvalidPlanConfigurationException("Hours per day must be between 0 and 10000000.");
                }
                hasPrev = PlanConfigurationSQL.addFieldSetter(hasPrev, PlanConfigurationSQL.HOURS_PER_DAY, configuration.getHoursPerDay(), generator);
                hasPrev = PlanConfigurationSQL.addFieldSetter(hasPrev, PlanConfigurationSQL.DAYS_IN_WEEK, configuration.getWeekdayConfiguration() != null ? Integer.valueOf(configuration.getWeekdayConfiguration().toInteger()) : null, generator);
                hasPrev = PlanConfigurationSQL.addFieldSetter(hasPrev, PlanConfigurationSQL.SUGGEST_REPLANNING_ESTIMATES, configuration.getSuggestReplEstimates(), generator);
                hasPrev = PlanConfigurationSQL.addFieldSetter(hasPrev, PlanConfigurationSQL.SYNC_STORIES, configuration.getSyncStories(), generator);
                hasPrev = PlanConfigurationSQL.addFieldSetter(hasPrev, PlanConfigurationSQL.SYNC_EPICS, configuration.getSyncEpics(), generator);
                hasPrev = PlanConfigurationSQL.addFieldSetter(hasPrev, PlanConfigurationSQL.SYNC_INITIATIVES, configuration.getSyncInitiatives(), generator);
                hasPrev = PlanConfigurationSQL.addFieldSetter(hasPrev, PlanConfigurationSQL.SYNC_SUMMARY, configuration.getSyncSummary(), generator);
                hasPrev = PlanConfigurationSQL.addFieldSetter(hasPrev, PlanConfigurationSQL.SYNC_DESCRIPTION, configuration.getSyncDescription(), generator);
                hasPrev = PlanConfigurationSQL.addFieldSetter(hasPrev, PlanConfigurationSQL.SYNC_ESTIMATES, configuration.getSyncEstimates(), generator);
                generator.where().colNoAlias("c", "aoplan").eq().numeric(planId);
            }
        });
    }

    private static boolean addFieldSetterForPotentiallyAbsentDouble(boolean hasPrev, String column, Double value, AOQueryGenerator generator) {
        boolean valueShouldBeDeleted;
        boolean bl = valueShouldBeDeleted = value != null && value == -1.0;
        if (valueShouldBeDeleted) {
            return PlanConfigurationSQL.addNullFieldSetter(hasPrev, column, generator);
        }
        return PlanConfigurationSQL.addFieldSetter(hasPrev, column, value, generator);
    }

    private static boolean addNullFieldSetter(boolean hasPrev, String column, AOQueryGenerator generator) {
        if (hasPrev) {
            generator.raw(",");
        }
        generator.colNoAlias("c", column).eq();
        generator.nullValue();
        return true;
    }

    private static <T> boolean addFieldSetter(boolean hasPrev, String column, T value, AOQueryGenerator generator) {
        if (value != null) {
            if (hasPrev) {
                generator.raw(",");
            }
            generator.colNoAlias("c", column).eq();
            if (value instanceof Integer) {
                generator.numeric((Integer)value);
            } else if (value instanceof Long) {
                generator.numeric((Long)value);
            } else if (value instanceof Double) {
                generator.numeric((Double)value);
            } else if (value instanceof String) {
                generator.str(value);
            } else if (value instanceof Boolean) {
                generator.bool((Boolean)value);
            } else if (value.getClass().isEnum()) {
                generator.str(value.toString());
            } else {
                throw new RuntimeException("Unknown type for config field setter.");
            }
            return true;
        }
        return hasPrev;
    }

    public void removePlanConfiguration(final String planId) throws SQLException {
        this.sql(new IUpdate(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.withTable(AOPlanConfiguration.class, "c").deleteFrom().tableNoAlias("c").where().colNoAlias("c", "aoplan").eq().numeric(planId);
            }
        });
    }
}

