/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.persistence.ao.upgrade.tasks;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.radiantminds.roadmap.common.data.activeobjects.ActiveObjectsUtilities;
import com.radiantminds.roadmap.common.data.persistence.PersistenceIndex;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.people.AOAbility;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.people.AOPerson;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.people.AOResource;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.people.AOTeam;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.skills.AOSkill;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.skills.AOStage;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.AOQueryGenerator;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.BaseAOPersistenceSQL;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.statements.IInsert;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.statements.IQuery;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.statements.IUpdate;
import com.radiantminds.roadmap.common.data.persistence.ao.upgrade.BaseUpgradeTask;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class U_01000_PersonToPlanUpgradeTask
extends BaseUpgradeTask {
    @Override
    protected int getDataModelVersion() {
        return 1000;
    }

    @Override
    protected void performUpgrade(ActiveObjectsUtilities utils, PersistenceIndex persistenceIndex) throws Exception {
        new UpgradeSQL(utils).movePersonsToPlan(this, utils);
    }

    @Override
    protected boolean migrateOnUpgrade() {
        return true;
    }

    private static class UpgradeSQL
    extends BaseAOPersistenceSQL {
        public UpgradeSQL(ActiveObjectsUtilities utils) {
            super(utils);
        }

        public void movePersonsToPlan(BaseUpgradeTask task, ActiveObjectsUtilities utils) throws SQLException {
            Map<String, List<VirtualPerson>> neededPersons = this.sql(new IQuery<Map<String, List<VirtualPerson>>>(){

                @Override
                public void sql(AOQueryGenerator generator) throws Exception {
                    generator.withTable(AOResource.class, "r").withTable(AOPerson.class, "p").withTable(AOTeam.class, "t").select().colId("p").col("t", "aoPlan").colId("r").from("r").leftJoin().table("p").on().colId("p").eq().col("r", "aoperson").leftJoin().table("t").on().colId("t").eq().col("r", "aoteam").where().col("p", "aoplan").isNull();
                }

                @Override
                public Map<String, List<VirtualPerson>> handleResult(ResultSet result) throws Exception {
                    HashMap retVal = Maps.newHashMap();
                    while (result.next()) {
                        String personId = BaseAOPersistenceSQL.getString(result, 1);
                        String planId = BaseAOPersistenceSQL.getString(result, 2);
                        String resourceId = BaseAOPersistenceSQL.getString(result, 3);
                        VirtualPerson vPerson = new VirtualPerson();
                        vPerson.planId = planId;
                        if (!retVal.containsKey(personId)) {
                            retVal.put(personId, Lists.newArrayList());
                            vPerson.newId = personId;
                        } else {
                            vPerson.newId = null;
                        }
                        boolean found = false;
                        for (VirtualPerson p : (List)retVal.get(personId)) {
                            if (!p.planId.equals(planId)) continue;
                            found = true;
                            vPerson = p;
                            break;
                        }
                        if (!found) {
                            ((List)retVal.get(personId)).add(vPerson);
                        }
                        vPerson.resourceIds.add(resourceId);
                    }
                    return retVal;
                }
            }, task.getOrCreateConnection(utils.getAccessor()));
            for (final String originalPersonId : neededPersons.keySet()) {
                for (final VirtualPerson person : neededPersons.get(originalPersonId)) {
                    if (person.newId != null && originalPersonId.equals(person.newId)) {
                        this.sql(new IUpdate(){

                            @Override
                            public void sql(AOQueryGenerator generator) throws Exception {
                                generator.withTable(AOPerson.class, "p").update().tableNoAlias("p").set().colNoAlias("p", "aoPlan").eq().numeric(person.planId).where().colIdNoAlias("p").eq().numeric(originalPersonId);
                            }
                        }, task.getOrCreateConnection(utils.getAccessor()));
                        continue;
                    }
                    final PersonCopy personToCopy = this.sql(new IQuery<PersonCopy>(){

                        @Override
                        public void sql(AOQueryGenerator generator) throws Exception {
                            generator.withTable(AOPerson.class, "p").select().colNoAlias("p", "aOExternal").colNoAlias("p", "description").colNoAlias("p", "title").colNoAlias("p", "version").colNoAlias("p", "details").from("p").where().colIdNoAlias("p").eq().numeric(originalPersonId);
                        }

                        @Override
                        public PersonCopy handleResult(ResultSet result) throws Exception {
                            if (result.next()) {
                                PersonCopy p = new PersonCopy();
                                p.aOExternal = BaseAOPersistenceSQL.getString(result, 1);
                                p.description = BaseAOPersistenceSQL.getString(result, 2);
                                p.title = BaseAOPersistenceSQL.getString(result, 3);
                                p.version = BaseAOPersistenceSQL.getInt(result, 4);
                                p.details = BaseAOPersistenceSQL.getString(result, 5);
                                return p;
                            }
                            return null;
                        }
                    }, task.getOrCreateConnection(utils.getAccessor()));
                    person.newId = this.sql(new IInsert(){

                        @Override
                        public void sql(AOQueryGenerator generator) throws Exception {
                            generator.withTable(AOPerson.class, "p").insert().tableNoAlias("p").raw("(").colNoAlias("p", "aOExternal").colNoAlias("p", "description").colNoAlias("p", "title").colNoAlias("p", "version").colNoAlias("p", "details").colNoAlias("p", "aoPlan").raw(") VALUES (").numeric(personToCopy.aOExternal).raw(",").str(personToCopy.description).raw(",").str(personToCopy.title).raw(",").numeric(personToCopy.version).raw(",").str(personToCopy.details).raw(",").numeric(person.planId).raw(")");
                        }

                        @Override
                        public void handleResult(String newId) throws Exception {
                        }
                    }, task.getOrCreateConnection(utils.getAccessor()));
                    this.sql(new IUpdate(){

                        @Override
                        public void sql(AOQueryGenerator generator) throws Exception {
                            generator.withTable(AOResource.class, "r").update().tableNoAlias("r").set().colNoAlias("r", "aoPerson").eq().numeric(person.newId).where().inNumeric(new AOQueryGenerator.InOperandCallback(){

                                @Override
                                public void generateOperand(AOQueryGenerator generator) {
                                    generator.colIdNoAlias("r");
                                }
                            }, person.resourceIds);
                        }
                    }, task.getOrCreateConnection(utils.getAccessor()));
                    this.sql(new IUpdate(){

                        @Override
                        public void sql(AOQueryGenerator generator) throws Exception {
                            generator.withTable(AOAbility.class, "a").withTable(AOStage.class, "s").update().tableNoAlias("a").set().colNoAlias("a", "aoPerson").eq().numeric(person.newId).where().colNoAlias("a", "targetType").eq().str("stage").and().colNoAlias("a", "aoPerson").eq().numeric(originalPersonId).and().colNoAlias("a", "targetId").raw("IN (").select().colIdNoAlias("s").from(new String[0]).tableNoAlias("s").where().colNoAlias("s", "aoPlan").eq().numeric(person.planId).raw(")");
                        }
                    }, task.getOrCreateConnection(utils.getAccessor()));
                    this.sql(new IUpdate(){

                        @Override
                        public void sql(AOQueryGenerator generator) throws Exception {
                            generator.withTable(AOAbility.class, "a").withTable(AOStage.class, "s").withTable(AOSkill.class, "k").update().tableNoAlias("a").set().colNoAlias("a", "aoPerson").eq().numeric(person.newId).where().colNoAlias("a", "targetType").eq().str("skill").and().colNoAlias("a", "aoPerson").eq().numeric(originalPersonId).and().colNoAlias("a", "targetId").raw("IN (").select().colIdNoAlias("k").from(new String[0]).tableNoAlias("k").where().colNoAlias("k", "aoStage").raw("IN (").select().colIdNoAlias("s").from(new String[0]).tableNoAlias("s").where().colNoAlias("s", "aoPlan").eq().numeric(person.planId).raw(")").raw(")");
                        }
                    }, task.getOrCreateConnection(utils.getAccessor()));
                }
            }
        }
    }

    private static class PersonCopy {
        public String aOExternal;
        public String description;
        public String title;
        public Integer version;
        public String details;

        private PersonCopy() {
        }
    }

    private static class VirtualPerson {
        public String newId;
        public String planId;
        public List<String> resourceIds = Lists.newArrayList();

        private VirtualPerson() {
        }
    }
}

