/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.extensions.releases;

import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.rm.jpo.scheduling.util.RmUtils;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.radiantminds.roadmap.common.data.entities.common.IExtensionLink;
import com.radiantminds.roadmap.common.data.entities.releases.IRelease;
import com.radiantminds.roadmap.common.extensions.releases.ReleaseExtension;
import com.radiantminds.roadmap.common.extensions.releases.ReleaseExtensionDataRequest;
import com.radiantminds.roadmap.common.extensions.releases.ReleaseExtensionLinkData;
import com.radiantminds.roadmap.common.extensions.releases.ReleasesExtensionData;
import com.radiantminds.roadmap.common.extensions.releases.ReleasesExtensionDataBulkRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ReleaseExtensionsDataRetrieval {
    private static final Log LOGGER = Log.with(ReleaseExtensionsDataRetrieval.class);
    private final ReleaseExtension releaseExtension;

    ReleaseExtensionsDataRetrieval(ReleaseExtension releaseExtension) {
        this.releaseExtension = releaseExtension;
    }

    public Map<IRelease, Set<ReleaseExtensionLinkData>> getExtensionLinkData(Set<IRelease> releases) throws Exception {
        Preconditions.checkNotNull(releases, (Object)"release set must not be null");
        LOGGER.debug("get extension link data for releases: %s", Joiner.on((String)",").join(releases));
        HashMap releaseToLinkDataMap = Maps.newHashMap();
        ReleaseExtensionDataRequest request = ReleasesExtensionDataBulkRequest.createFromReleases(releases);
        ReleasesExtensionData releasesExtensionData = this.releaseExtension.getReleasesExtensionData(request);
        this.mergeData(releases, releasesExtensionData, releaseToLinkDataMap);
        LOGGER.debug("data retrieval successful", new Object[0]);
        return releaseToLinkDataMap;
    }

    public ReleaseExtensionLinkData getExtensionLinkDataForSingleLink(String link) throws Exception {
        Preconditions.checkNotNull((Object)link, (Object)"Link version id must not be null");
        ReleaseExtensionDataRequest request = ReleasesExtensionDataBulkRequest.createForLink(link);
        ReleasesExtensionData data = this.releaseExtension.getReleasesExtensionData(request);
        if (data.getErrorsById().isEmpty()) {
            return data.getEnrichtmentData().get(link);
        }
        return null;
    }

    private void mergeData(Set<IRelease> releases, ReleasesExtensionData releasesExtensionData, Map<IRelease, Set<ReleaseExtensionLinkData>> releaseToLinkDataMap) {
        Map<String, ReleaseExtensionLinkData> linkData = releasesExtensionData.getEnrichtmentData();
        for (IRelease release : releases) {
            List<IExtensionLink> releaseLinks = release.getExtensionLinks();
            for (IExtensionLink releaseLink : releaseLinks) {
                String linkString = releaseLink.getExtensionLink();
                if (!linkData.containsKey(linkString)) continue;
                RmUtils.addToKeyedSets(releaseToLinkDataMap, release, linkData.get(linkString));
            }
        }
    }

    public static ReleaseExtensionsDataRetrieval create(ReleaseExtension releaseExtension) {
        return new ReleaseExtensionsDataRetrieval(releaseExtension);
    }
}

