/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.handlers;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.springframework.stereotype.Component;

@Component
public class ClientIdCache {
    private static final long MAX_CACHE_ENTRIES = 100L;
    private static final long CACHE_ENTRY_EXPIRY_DURATION = 5L;
    private static final TimeUnit CACHE_ENTRY_EXPIRY_UNIT = TimeUnit.SECONDS;
    private final Cache<EntityCacheKey, String> entityClientCache = CacheBuilder.newBuilder().maximumSize(100L).expireAfterWrite(5L, CACHE_ENTRY_EXPIRY_UNIT).build();

    public void clientAccessedEntity(Class entityClass, String entityId, String clientId) {
        if (clientId == null) {
            return;
        }
        this.entityClientCache.put((Object)this.key(entityClass, entityId), (Object)clientId);
    }

    public boolean isClientLastAccessorOfEntity(Class entityClass, String entityId, String clientId) {
        if (clientId == null) {
            return false;
        }
        String lastClientToAccessEntity = (String)this.entityClientCache.getIfPresent((Object)this.key(entityClass, entityId));
        return clientId.equals(lastClientToAccessEntity);
    }

    private EntityCacheKey key(Class entityClass, String entityId) {
        return new EntityCacheKey(entityClass, entityId);
    }

    private class EntityCacheKey {
        private final Class entityClass;
        private final String entityId;

        public EntityCacheKey(Class entityClass, String entityId) {
            this.entityClass = entityClass;
            this.entityId = entityId;
        }

        public boolean equals(Object o) {
            if (o instanceof EntityCacheKey) {
                EntityCacheKey other = (EntityCacheKey)o;
                return this.entityClass.equals(other.entityClass) && this.entityId.equals(other.entityId);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.entityClass, this.entityId);
        }
    }
}

