/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.handlers.sync;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.radiantminds.roadmap.common.data.entities.common.IExtendable;
import com.radiantminds.roadmap.common.data.entities.common.IExtensionLink;
import com.radiantminds.roadmap.common.data.entities.releases.IRelease;
import com.radiantminds.roadmap.common.data.entities.workitems.IWorkItem;
import com.radiantminds.roadmap.common.handlers.common.violations.ViolationMessage;
import com.radiantminds.roadmap.common.handlers.sync.DuplicateLinkDetailsProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

public abstract class SyncUtils {
    private static final String MSG_DUPLICATE_ISSUE_LINKS = "sync-duplicate-issue-link";
    private static final String MSG_DUPLICATE_VERSION_LINKS = "sync-duplicate-version-link";

    private SyncUtils() {
    }

    public static List<ViolationMessage> checkForDuplicateIssueLinks(Collection<IWorkItem> workItems, DuplicateLinkDetailsProvider detailsProvider) {
        return SyncUtils.checkDuplicates(workItems, MSG_DUPLICATE_ISSUE_LINKS, detailsProvider);
    }

    public static List<ViolationMessage> checkForDuplicateReleaseLinks(Collection<IRelease> releases, DuplicateLinkDetailsProvider detailsProvider) {
        return SyncUtils.checkDuplicates(releases, MSG_DUPLICATE_VERSION_LINKS, detailsProvider);
    }

    private static List<ViolationMessage> checkDuplicates(Collection<? extends IExtendable> extendables, String message, DuplicateLinkDetailsProvider detailsProvider) {
        ArrayList retVal = Lists.newArrayList();
        HashSet links = Sets.newHashSet();
        HashSet duplicates = Sets.newHashSet();
        for (IExtendable iExtendable : extendables) {
            List<IExtensionLink> extensionLinks = iExtendable.getExtensionLinks();
            for (IExtensionLink link : extensionLinks) {
                String extensionLink = link.getExtensionLink();
                String linkDetails = detailsProvider.getDetailsInfoForLink(extensionLink);
                if (linkDetails == null) continue;
                if (links.contains(extensionLink)) {
                    if (duplicates.contains(extensionLink)) continue;
                    ViolationMessage.Impl msg = new ViolationMessage.Impl("warning", message, detailsProvider.getDetailsInfoForLink(extensionLink));
                    retVal.add(msg);
                    duplicates.add(extensionLink);
                    continue;
                }
                links.add(extensionLink);
            }
        }
        return retVal;
    }
}

