/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.rest.entities.system;

import com.google.common.collect.Lists;
import com.radiantminds.roadmap.common.extensions.filters.IssueFilterDescription;
import com.radiantminds.roadmap.common.extensions.filters.IssueFilterSearchResult;
import com.radiantminds.roadmap.common.rest.entities.system.RestIssueFilterDescription;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="result")
@XmlAccessorType(value=XmlAccessType.NONE)
public class RestIssueFilterSearchResult {
    @XmlElement
    private List<RestIssueFilterDescription> filters;
    @XmlElement
    Integer filterCount;

    @Deprecated
    private RestIssueFilterSearchResult() {
    }

    private RestIssueFilterSearchResult(List<RestIssueFilterDescription> filters) {
        this(filters, filters.size());
    }

    private RestIssueFilterSearchResult(List<RestIssueFilterDescription> filters, int filterCount) {
        this.filters = filters;
        this.filterCount = filterCount;
    }

    public static RestIssueFilterSearchResult build(IssueFilterSearchResult result) {
        return new RestIssueFilterSearchResult(RestIssueFilterSearchResult.toRestFilterDescriptionList(result), result.getTotalFilters());
    }

    private static final List<RestIssueFilterDescription> toRestFilterDescriptionList(IssueFilterSearchResult input) {
        if (input == null) {
            return null;
        }
        ArrayList output = Lists.newArrayList();
        for (IssueFilterDescription filter : input.getFilters()) {
            output.add(new RestIssueFilterDescription(filter.getId(), filter.getName(), filter.getJql(), filter.getFavourite()));
        }
        return output;
    }
}

