/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.rest.entities.workitems.status;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.radiantminds.roadmap.common.rest.entities.common.RestVersionedId;
import com.radiantminds.roadmap.common.rest.entities.workitems.status.RestBulkWorkItemStatusEntry;
import com.radiantminds.roadmap.common.rest.entities.workitems.status.RestWorkItemStatus;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="workItemStatus")
@XmlAccessorType(value=XmlAccessType.NONE)
public class RestBulkWorkItemStatus {
    @XmlElement
    private Integer status;
    @XmlElement
    private List<RestBulkWorkItemStatusEntry> items;

    @Deprecated
    private RestBulkWorkItemStatus() {
    }

    public RestBulkWorkItemStatus(Integer status, List<RestBulkWorkItemStatusEntry> items) {
        this.status = status;
        this.items = items;
    }

    public Integer getStatus() {
        return this.status;
    }

    public List<RestBulkWorkItemStatusEntry> getItems() {
        return this.items;
    }

    public List<RestVersionedId> getIds() {
        if (this.items == null) {
            return Lists.newArrayList();
        }
        return Lists.newArrayList(this.items);
    }

    public Map<String, RestWorkItemStatus> getStatusMap() {
        HashMap retVal = Maps.newHashMap();
        for (RestBulkWorkItemStatusEntry entry : this.items) {
            RestWorkItemStatus status = new RestWorkItemStatus(this.status);
            status.setTeamResourceAssignment(entry.getTeamResourceAssignment());
            status.setStreamReleaseAssignment(entry.getStreamReleaseAssignment());
            retVal.put(entry.getId(), status);
        }
        return retVal;
    }
}

