/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.rest.services.common;

import com.atlassian.pocketknife.api.logging.Log;
import com.google.common.collect.Lists;
import com.radiantminds.roadmap.common.rest.services.common.SchedulingRelevantPatch;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;

public class SchedulingRelevantPatchChecker {
    private static final Log LOGGER = Log.with(SchedulingRelevantPatchChecker.class);

    public static boolean test(Object subject) {
        List<Field> fields = SchedulingRelevantPatchChecker.getFieldsRecursive(subject.getClass());
        for (Field field : fields) {
            if (!field.isAnnotationPresent(SchedulingRelevantPatch.class)) continue;
            field.setAccessible(true);
            try {
                if (field.get(subject) == null) continue;
                return true;
            }
            catch (IllegalAccessException e) {
                LOGGER.exception(e, Log.LogLevel.WARN);
            }
        }
        return false;
    }

    private static List<Field> getFieldsRecursive(Class<?> clazz) {
        ArrayList retVal = Lists.newArrayList((Object[])clazz.getDeclaredFields());
        Class<?> parentClazz = clazz.getSuperclass();
        if (parentClazz != null && parentClazz != Object.class) {
            List<Field> parentClassFields = SchedulingRelevantPatchChecker.getFieldsRecursive(parentClazz);
            retVal.addAll(parentClassFields);
        }
        return retVal;
    }
}

