/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.rest.services.configuration;

import com.radiantminds.roadmap.common.data.activeobjects.ActiveObjectsUtilities;
import com.radiantminds.roadmap.common.data.entities.plans.IPlan;
import com.radiantminds.roadmap.common.data.entities.plans.IPlanConfiguration;
import com.radiantminds.roadmap.common.data.entities.plans.PlanningUnit;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.people.sql.TeamSQL;
import com.radiantminds.roadmap.common.data.persistence.services.PortfolioPlanPersistence;
import com.radiantminds.roadmap.common.handlers.EntityContext;
import com.radiantminds.roadmap.common.handlers.VersionIncrementMode;
import com.radiantminds.roadmap.common.handlers.annotations.AuthorizedPlanReadAccess;
import com.radiantminds.roadmap.common.handlers.annotations.AuthorizedPlanUserAccess;
import com.radiantminds.roadmap.common.rest.common.ResponseBuilder;
import com.radiantminds.roadmap.common.rest.entities.common.ModificationResult;
import com.radiantminds.roadmap.common.rest.entities.common.messaging.RestMessaging;
import com.radiantminds.roadmap.common.rest.entities.plans.RestPlanConfiguration;
import com.radiantminds.roadmap.common.rest.services.common.SchedulingRelevantPatchChecker;
import javax.ws.rs.core.Response;

public interface PlanConfigurationServiceHandler {
    @AuthorizedPlanReadAccess
    public Response getPlanConfiguration(EntityContext<IPlan> var1) throws Exception;

    @AuthorizedPlanUserAccess(incrementEntityVersion=VersionIncrementMode.Off, incrementPlanVersion=VersionIncrementMode.On, incrementSchedulingVersion=VersionIncrementMode.Dynamic)
    public Response patchPlanConfigurationWithPost(EntityContext<IPlan> var1, RestPlanConfiguration var2) throws Exception;

    public static class Impl
    implements PlanConfigurationServiceHandler {
        private final TeamSQL teamSQL;
        private final PortfolioPlanPersistence planPersistence;

        public Impl(ActiveObjectsUtilities activeObjectsUtilities, PortfolioPlanPersistence planPersistence) {
            this.teamSQL = new TeamSQL(activeObjectsUtilities);
            this.planPersistence = planPersistence;
        }

        @Override
        public Response getPlanConfiguration(EntityContext<IPlan> entityContext) throws Exception {
            IPlanConfiguration config = this.planPersistence.getPlanConfiguration(entityContext.getEntityId());
            return entityContext.ok(config);
        }

        @Override
        public Response patchPlanConfigurationWithPost(EntityContext<IPlan> entityContext, RestPlanConfiguration planConfiguration) throws Exception {
            entityContext.setIncrementSchedulingVersion(SchedulingRelevantPatchChecker.test(planConfiguration));
            String planId = entityContext.getEntityId();
            if (PlanningUnit.STORY_POINTS.unit().equals(planConfiguration.getPlanningUnit()) && !this.teamSQL.allTeamsInPlanUseScrum(planId).booleanValue()) {
                return ResponseBuilder.badRequest(RestMessaging.warning("config-story-points-not-allowed"));
            }
            this.planPersistence.setPlanConfiguration(planId, planConfiguration);
            return entityContext.ok(new ModificationResult());
        }
    }
}

