/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.rest.services.exportimport;

import com.radiantminds.roadmap.common.data.activeobjects.ActiveObjectsUtilities;
import com.radiantminds.roadmap.common.data.persistence.ao.port.PlanImporter;
import com.radiantminds.roadmap.common.data.persistence.ao.port.PortProgress;
import com.radiantminds.roadmap.common.data.persistence.ao.port.XmlExportablePersistenceIndex;
import com.radiantminds.roadmap.common.data.persistence.ao.port.dynamics.DynamicValueHandlers;
import com.radiantminds.roadmap.common.data.persistence.ao.port.legacy.DocumentLegacyChecker;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioPermissionPersistence;
import com.radiantminds.roadmap.common.extensions.users.UserExtension;
import com.radiantminds.roadmap.common.handlers.annotations.AuthorizedPluginUserAccess;
import com.radiantminds.roadmap.common.rest.common.ResponseBuilder;
import com.radiantminds.roadmap.common.rest.entities.common.ModificationResult;
import com.radiantminds.roadmap.common.rest.utils.async.LongRunningService;
import com.radiantminds.roadmap.common.rest.utils.async.LongRunningServiceTask;
import com.radiantminds.roadmap.common.scheduling.entities.SchedulingPlanFactory;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Response;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.IOUtils;

public interface ImportServiceHandler {
    @AuthorizedPluginUserAccess
    public Response importPlan(HttpServletRequest var1) throws Exception;

    public static class Impl
    implements ImportServiceHandler {
        private final ServletFileUpload fileUpload;
        private final PlanImporter planImporter;
        private final UserExtension userExtension;
        private final LongRunningService longRunningService;

        public Impl(XmlExportablePersistenceIndex index, SchedulingPlanFactory schedulingPlanFactory, DocumentLegacyChecker documentLegacyChecker, ActiveObjectsUtilities activeObjectsUtilities, UserExtension userExtension, PortfolioPermissionPersistence permissionPersistence, LongRunningService longRunningService, DynamicValueHandlers dynamicValueHandlers) {
            this.userExtension = userExtension;
            this.longRunningService = longRunningService;
            this.fileUpload = new ServletFileUpload(new DiskFileItemFactory());
            this.fileUpload.setFileSizeMax(100000000L);
            this.planImporter = new PlanImporter(index, activeObjectsUtilities, schedulingPlanFactory, documentLegacyChecker, permissionPersistence, dynamicValueHandlers);
        }

        @Override
        public Response importPlan(HttpServletRequest request) throws Exception {
            final List<FileItem> items = this.fileUpload.parseRequest(request);
            final String userId = this.userExtension != null ? this.userExtension.getActiveUserData().getUserID() : null;
            return this.longRunningService.service(new LongRunningServiceTask(){
                private PortProgress progress = new PortProgress();

                @Override
                public Response execute() throws Exception {
                    String planXml = Impl.extractItem("plan", items);
                    String accessMode = Impl.extractItem("accessmode", items);
                    String title = Impl.extractItem("title", items);
                    String description = Impl.extractItem("description", items);
                    if (planXml != null) {
                        String planId = planImporter.importPlan(planXml, accessMode, title, description, null, userId, this.progress);
                        return ResponseBuilder.ok(new ModificationResult(null, planId));
                    }
                    return ResponseBuilder.badRequest();
                }

                @Override
                public Object getStatusEntity() {
                    return this.progress;
                }
            });
        }

        private static String extractItem(String key, List<FileItem> items) throws IOException {
            for (FileItem item : items) {
                if (!key.equals(item.getFieldName())) continue;
                StringWriter writer = new StringWriter();
                IOUtils.copy(item.getInputStream(), (Writer)writer, "UTF-8");
                String str = writer.toString();
                if (str.length() <= 0) continue;
                return str;
            }
            return null;
        }
    }
}

